<?php
require_once 'config.php';

// Require login
requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitize($_POST['name']);
    $city = sanitize($_POST['city']);
    $userId = $_SESSION['user_id'];
    
    // Validation
    if (empty($name) || strlen($name) < 2) {
        $_SESSION['error'] = 'يجب أن يكون الاسم أكثر من حرفين';
        redirect('dashboard.php#profile');
    }
    
    if (empty($city)) {
        $_SESSION['error'] = 'يرجى اختيار المدينة';
        redirect('dashboard.php#profile');
    }
    
    // Update user profile
    $stmt = $pdo->prepare("UPDATE users SET name = ?, city = ? WHERE id = ?");
    
    if ($stmt->execute([$name, $city, $userId])) {
        $_SESSION['user_name'] = $name;
        $_SESSION['success'] = 'تم حفظ التغييرات بنجاح';
    } else {
        $_SESSION['error'] = 'حدث خطأ أثناء حفظ التغييرات';
    }
}

redirect('dashboard.php#profile');
?>
