<?php
$page_title = 'ملفي الشخصي';
require_once 'includes/dashboard_header.php';

$success = '';
$error = '';

// Handle profile update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitize($_POST['name']);
    $phone = sanitize($_POST['phone']);
    $city = sanitize($_POST['city']);
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    
    if (empty($name) || empty($phone) || empty($city)) {
        $error = 'يرجى ملء جميع الحقول المطلوبة';
    } elseif (!validatePhone($phone)) {
        $error = 'رقم الهاتف غير صحيح';
    } else {
        // Check if phone number is taken by another user (only if phone was changed)
        $stmt = $pdo->prepare("SELECT phone FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $current_user_phone = $stmt->fetch()['phone'];
        
        // Only check for duplicate phone if user is changing their phone number
        if ($phone !== $current_user_phone) {
            $stmt = $pdo->prepare("SELECT id FROM users WHERE phone = ?");
            $stmt->execute([$phone]);
            
            if ($stmt->fetch()) {
                $error = 'رقم الهاتف مستخدم من قبل مستخدم آخر';
            }
        }
        
        if (!$error) {
            // Update basic info
            $stmt = $pdo->prepare("UPDATE users SET name = ?, phone = ?, city = ? WHERE id = ?");
            
            if ($stmt->execute([$name, $phone, $city, $_SESSION['user_id']])) {
                $_SESSION['user_name'] = $name;
                
                // Handle password change if provided
                if (!empty($current_password) && !empty($new_password)) {
                    // Verify current password
                    $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
                    $stmt->execute([$_SESSION['user_id']]);
                    $user_data = $stmt->fetch();
                    
                    if (password_verify($current_password, $user_data['password'])) {
                        if (strlen($new_password) >= 6) {
                            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                            $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
                            $stmt->execute([$hashed_password, $_SESSION['user_id']]);
                            $success = 'تم تحديث الملف الشخصي وكلمة المرور بنجاح';
                        } else {
                            $error = 'كلمة المرور الجديدة يجب أن تكون 6 أحرف على الأقل';
                        }
                    } else {
                        $error = 'كلمة المرور الحالية غير صحيحة';
                    }
                } else {
                    $success = 'تم تحديث الملف الشخصي بنجاح';
                }
            } else {
                $error = 'حدث خطأ أثناء التحديث';
            }
        }
    }
    
    // Refresh user data
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
}
?>

<div class="dashboard-container">
    <?php include 'includes/dashboard_sidebar.php'; ?>

    <main class="main-content">
        <?php include 'includes/dashboard_topbar.php'; ?>
        
        <div class="content-wrapper">
            <section class="content-section">
    <div class="section-header">
        <h2>ملفي الشخصي</h2>
        <p>إدارة معلوماتك الشخصية</p>
    </div>

    <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo $success; ?>
        </div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <div class="profile-container">
        <div class="profile-card">
            <div class="profile-header">
                <div class="profile-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="profile-info">
                    <h3><?php echo htmlspecialchars($user['name']); ?></h3>
                    <p>عضو منذ <?php echo date('d/m/Y', strtotime($user['created_at'])); ?></p>
                </div>
            </div>

            <form method="POST" class="profile-form">
                <div class="form-section">
                    <h4>المعلومات الأساسية</h4>
                    
                    <div class="form-group">
                        <label for="name">الاسم الكامل</label>
                        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="phone">رقم الهاتف</label>
                        <input type="tel" id="phone" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="city">المدينة</label>
                        <select id="city" name="city" required>
                            <option value="">اختر المدينة</option>
                            <option value="الرباط" <?php echo $user['city'] === 'الرباط' ? 'selected' : ''; ?>>الرباط</option>
                            <option value="الدار البيضاء" <?php echo $user['city'] === 'الدار البيضاء' ? 'selected' : ''; ?>>الدار البيضاء</option>
                            <option value="فاس" <?php echo $user['city'] === 'فاس' ? 'selected' : ''; ?>>فاس</option>
                            <option value="مراكش" <?php echo $user['city'] === 'مراكش' ? 'selected' : ''; ?>>مراكش</option>
                            <option value="أكادير" <?php echo $user['city'] === 'أكادير' ? 'selected' : ''; ?>>أكادير</option>
                            <option value="طنجة" <?php echo $user['city'] === 'طنجة' ? 'selected' : ''; ?>>طنجة</option>
                            <option value="مكناس" <?php echo $user['city'] === 'مكناس' ? 'selected' : ''; ?>>مكناس</option>
                            <option value="وجدة" <?php echo $user['city'] === 'وجدة' ? 'selected' : ''; ?>>وجدة</option>
                        </select>
                    </div>
                </div>

                <div class="form-section">
                    <h4>تغيير كلمة المرور (اختياري)</h4>
                    
                    <div class="form-group">
                        <label for="current_password">كلمة المرور الحالية</label>
                        <input type="password" id="current_password" name="current_password">
                    </div>

                    <div class="form-group">
                        <label for="new_password">كلمة المرور الجديدة</label>
                        <input type="password" id="new_password" name="new_password">
                        <small>يجب أن تكون 6 أحرف على الأقل</small>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        حفظ التغييرات
                    </button>
                </div>
            </form>
        </div>
            </div>
            </section>
        </div>
    </main>
</div>

<?php require_once 'includes/dashboard_footer.php'; ?>
