<?php
require_once 'config.php';

// Require login
requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rideId = (int)$_POST['ride_id'];
    $userId = $_SESSION['user_id'];
    
    // Check if ride exists and is in the future
    $stmt = $pdo->prepare("SELECT * FROM rides WHERE id = ? AND date >= CURDATE()");
    $stmt->execute([$rideId]);
    $ride = $stmt->fetch();
    
    if (!$ride) {
        echo json_encode(['success' => false, 'message' => 'الخرجة غير موجودة أو انتهت']);
        exit;
    }
    
    // Check if user already joined
    $stmt = $pdo->prepare("SELECT id FROM ride_participants WHERE user_id = ? AND ride_id = ?");
    $stmt->execute([$userId, $rideId]);
    
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'أنت منضم بالفعل لهذه الخرجة']);
        exit;
    }
    
    // Check if ride is full
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM ride_participants WHERE ride_id = ?");
    $stmt->execute([$rideId]);
    $participantsCount = $stmt->fetch()['count'];
    
    if ($participantsCount >= $ride['max_participants']) {
        echo json_encode(['success' => false, 'message' => 'الخرجة مكتملة العدد']);
        exit;
    }
    
    // Join the ride
    $stmt = $pdo->prepare("INSERT INTO ride_participants (user_id, ride_id) VALUES (?, ?)");
    
    if ($stmt->execute([$userId, $rideId])) {
        echo json_encode(['success' => true, 'message' => 'تم الانضمام للخرجة بنجاح!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'حدث خطأ أثناء الانضمام']);
    }
    exit;
}

// If not POST request, redirect to dashboard
redirect('dashboard.php');
?>
