<?php
// Get current page for navigation highlighting
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Get user data if not already loaded
if (!isset($user)) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
}
?>
<!-- Sidebar -->
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <div class="logo">
            <i class="fas fa-motorcycle"></i>
            <span>رايد المغرب</span>
        </div>
        <button class="sidebar-toggle" id="sidebarToggle">
            <i class="fas fa-bars"></i>
        </button>
    </div>

    <nav class="sidebar-nav">
        <ul class="nav-list">
            <li class="nav-item">
                <a href="dashboard.php" class="nav-link <?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>الرئيسية</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="upcoming-rides.php" class="nav-link <?php echo $current_page === 'upcoming-rides' ? 'active' : ''; ?>">
                    <i class="fas fa-calendar-plus"></i>
                    <span>الخرجات القادمة</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="my-rides.php" class="nav-link <?php echo $current_page === 'my-rides' ? 'active' : ''; ?>">
                    <i class="fas fa-route"></i>
                    <span>خرجاتي</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="profile.php" class="nav-link <?php echo $current_page === 'profile' ? 'active' : ''; ?>">
                    <i class="fas fa-user"></i>
                    <span>ملفي الشخصي</span>
                </a>
            </li>
        </ul>
    </nav>

    <div class="sidebar-footer">
        <div class="user-info">
            <div class="user-avatar">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-details">
                <div class="user-name"><?php echo htmlspecialchars($user['name'] ?? 'المستخدم'); ?></div>
                <div class="user-role">عضو</div>
            </div>
        </div>
        <a href="logout.php" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i>
            <span>تسجيل الخروج</span>
        </a>
    </div>
</aside>
