-- Database setup for RideMorocco
-- Run this script on your web hosting MySQL database

CREATE DATABASE IF NOT EXISTS ridemorocco CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE ridemorocco;

-- Users table
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    phone VARCHAR(20) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    city VARCHAR(100) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Rides table
CREATE TABLE IF NOT EXISTS rides (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    date DATE NOT NULL,
    location VARCHAR(255) NOT NULL,
    max_participants INT DEFAULT 10,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE SET NULL
);

-- Ride participants table
CREATE TABLE IF NOT EXISTS ride_participants (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    ride_id INT NOT NULL,
    joined_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (ride_id) REFERENCES rides(id) ON DELETE CASCADE,
    UNIQUE KEY unique_participation (user_id, ride_id)
);

-- Insert sample rides
INSERT INTO rides (title, description, date, location, max_participants) VALUES
('مغامرة جبال الأطلس', 'رحلة مثيرة عبر جبال الأطلس الجميلة مع مناظر خلابة ومسارات ممتعة', '2024-12-15', 'الدار البيضاء - إفران', 15),
('جولة الساحل الأطلسي', 'استكشف جمال الساحل المغربي مع نسيم البحر والمناظر الساحرة', '2024-12-16', 'الرباط - الجديدة', 20),
('رحلة الصحراء الذهبية', 'مغامرة لا تُنسى في قلب الصحراء المغربية', '2024-12-20', 'مراكش - مرزوكة', 12),
('طريق الألف قصبة', 'اكتشف التراث المغربي عبر طريق القصبات التاريخية', '2024-12-22', 'ورزازات - تنغير', 18);
