<?php
$page_title = 'لوحة التحكم';
require_once 'includes/dashboard_header.php';

// Get user's rides count
$stmt = $pdo->prepare("SELECT COUNT(*) as count FROM ride_participants WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$userRidesCount = $stmt->fetch()['count'];

// Get upcoming rides count
$stmt = $pdo->prepare("SELECT COUNT(*) as count FROM rides WHERE date >= CURDATE()");
$stmt->execute();
$upcomingRidesCount = $stmt->fetch()['count'];
?>

<div class="dashboard-container">
    <?php include 'includes/dashboard_sidebar.php'; ?>

    <!-- Main Content -->
    <main class="main-content">
        <?php include 'includes/dashboard_topbar.php'; ?>

        <!-- Content Sections -->
        <div class="content-wrapper">
                <!-- Dashboard Section -->
                <section id="dashboard-section" class="content-section active">
                    <div class="stats-grid">
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-route"></i>
                            </div>
                            <div class="stat-info">
                                <h3><?php echo $userRidesCount; ?></h3>
                                <p>إجمالي الخرجات</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                            <div class="stat-info">
                                <h3><?php echo $upcomingRidesCount; ?></h3>
                                <p>خرجات قادمة</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="stat-info">
                                <h3>500+</h3>
                                <p>أعضاء المجتمع</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <div class="stat-info">
                                <h3>4.8</h3>
                                <p>تقييم المجتمع</p>
                            </div>
                        </div>
                    </div>

                    <div class="dashboard-grid">
                        <div class="dashboard-card">
                            <div class="card-header">
                                <h3>الخرجات القادمة</h3>
                                <a href="#upcoming-rides" class="view-all">عرض الكل</a>
                            </div>
                            <div class="card-content">
                                <div id="recentRides" class="rides-list">
                                    <?php
                                    $stmt = $pdo->prepare("SELECT * FROM rides WHERE date >= CURDATE() ORDER BY date ASC LIMIT 3");
                                    $stmt->execute();
                                    $recentRides = $stmt->fetchAll();
                                    
                                    if ($recentRides): ?>
                                        <?php foreach ($recentRides as $ride): ?>
                                            <div class="ride-item">
                                                <div class="ride-info">
                                                    <h4><?php echo htmlspecialchars($ride['title']); ?></h4>
                                                    <p><i class="fas fa-calendar"></i> <?php echo date('d/m/Y', strtotime($ride['date'])); ?></p>
                                                    <p><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($ride['location']); ?></p>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <p>لا توجد خرجات قادمة حالياً</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="dashboard-card">
                            <div class="card-header">
                                <h3>نشاطي الأخير</h3>
                            </div>
                            <div class="card-content">
                                <div class="activity-list">
                                    <div class="activity-item">
                                        <div class="activity-icon">
                                            <i class="fas fa-user-plus"></i>
                                        </div>
                                        <div class="activity-info">
                                            <p>انضممت إلى المجتمع</p>
                                            <span class="activity-time"><?php echo date('d/m/Y', strtotime($user['created_at'])); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Upcoming Rides Section -->
                <section id="upcoming-rides-section" class="content-section">
                    <div class="section-header">
                        <h2>الخرجات القادمة</h2>
                        <div class="filters">
                            <select id="cityFilter" class="filter-select">
                                <option value="">جميع المدن</option>
                                <option value="الدار البيضاء">الدار البيضاء</option>
                                <option value="الرباط">الرباط</option>
                                <option value="تمارة">تمارة</option>
                                <option value="المحمدية">المحمدية</option>
                                <option value="سطات">سطات</option>
                                <option value="سلا">سلا</option>
                                <option value="القنيطرة">القنيطرة</option>
                                <option value="الجديدة">الجديدة</option>
                                <option value="برشيد">برشيد</option>
                            </select>
                        </div>
                    </div>
                    <div id="upcomingRidesList" class="rides-grid">
                        <?php
                        $stmt = $pdo->prepare("
                            SELECT r.*, 
                                   COUNT(rp.user_id) as participants_count,
                                   MAX(CASE WHEN rp.user_id = ? THEN 1 ELSE 0 END) as user_joined
                            FROM rides r 
                            LEFT JOIN ride_participants rp ON r.id = rp.ride_id 
                            WHERE r.date >= CURDATE() 
                            GROUP BY r.id 
                            ORDER BY r.date ASC
                        ");
                        $stmt->execute([$_SESSION['user_id']]);
                        $upcomingRides = $stmt->fetchAll();
                        
                        foreach ($upcomingRides as $ride): ?>
                            <div class="ride-card">
                                <div class="ride-image">
                                    <img src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=500&q=80" alt="<?php echo htmlspecialchars($ride['title']); ?>">
                                    <div class="ride-badge"><?php echo $ride['user_joined'] ? 'منضم' : 'متاح'; ?></div>
                                </div>
                                <div class="ride-content">
                                    <h3><?php echo htmlspecialchars($ride['title']); ?></h3>
                                    <div class="ride-details">
                                        <div class="detail">
                                            <i class="fas fa-calendar"></i>
                                            <span><?php echo date('d/m/Y', strtotime($ride['date'])); ?></span>
                                        </div>
                                        <div class="detail">
                                            <i class="fas fa-map-marker-alt"></i>
                                            <span><?php echo htmlspecialchars($ride['location']); ?></span>
                                        </div>
                                        <div class="detail">
                                            <i class="fas fa-users"></i>
                                            <span><?php echo $ride['participants_count']; ?>/<?php echo $ride['max_participants']; ?> مشارك</span>
                                        </div>
                                    </div>
                                    <p class="ride-description"><?php echo htmlspecialchars($ride['description']); ?></p>
                                    <?php if ($ride['user_joined']): ?>
                                        <button class="btn btn-success btn-full" disabled>تم الانضمام</button>
                                    <?php else: ?>
                                        <button class="btn btn-primary join-ride-btn" data-ride-id="<?php echo $ride['id']; ?>">انضم للخرجة</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </section>

                <!-- My Rides Section -->
                <section id="my-rides-section" class="content-section">
                    <div class="section-header">
                        <h2>خرجاتي</h2>
                    </div>
                    <div class="tabs">
                        <button class="tab-btn active" data-tab="joined">انضممت إليها</button>
                        <button class="tab-btn" data-tab="completed">مكتملة</button>
                    </div>
                    <div id="myRidesList" class="rides-grid">
                        <?php
                        $stmt = $pdo->prepare("
                            SELECT r.* FROM rides r 
                            JOIN ride_participants rp ON r.id = rp.ride_id 
                            WHERE rp.user_id = ? AND r.date >= CURDATE()
                            ORDER BY r.date ASC
                        ");
                        $stmt->execute([$_SESSION['user_id']]);
                        $myRides = $stmt->fetchAll();
                        
                        if (empty($myRides)): ?>
                            <div class="empty-state">
                                <i class="fas fa-route"></i>
                                <h3>لم تنضم لأي خرجة بعد</h3>
                                <p>ابدأ مغامرتك وانضم إلى إحدى الخرجات القادمة</p>
                                <a href="#upcoming-rides" class="btn btn-primary">تصفح الخرجات</a>
                            </div>
                        <?php else: ?>
                            <?php foreach ($myRides as $ride): ?>
                                <div class="ride-card">
                                    <div class="ride-image">
                                        <img src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=500&q=80" alt="<?php echo htmlspecialchars($ride['title']); ?>">
                                        <div class="ride-badge">منضم</div>
                                    </div>
                                    <div class="ride-content">
                                        <h3><?php echo htmlspecialchars($ride['title']); ?></h3>
                                        <div class="ride-details">
                                            <div class="detail">
                                                <i class="fas fa-calendar"></i>
                                                <span><?php echo date('d/m/Y', strtotime($ride['date'])); ?></span>
                                            </div>
                                            <div class="detail">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <span><?php echo htmlspecialchars($ride['location']); ?></span>
                                            </div>
                                        </div>
                                        <p class="ride-description"><?php echo htmlspecialchars($ride['description']); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </section>

                <!-- Profile Section -->
                <section id="profile-section" class="content-section">
                    <div class="profile-container">
                        <div class="profile-header">
                            <div class="profile-avatar">
                                <i class="fas fa-user"></i>
                            </div>
                            <div class="profile-info">
                                <h2><?php echo htmlspecialchars($user['name']); ?></h2>
                                <p><?php echo htmlspecialchars($user['city']); ?></p>
                                <span class="member-since">عضو منذ <?php echo date('d/m/Y', strtotime($user['created_at'])); ?></span>
                            </div>
                        </div>

                        <div class="profile-content">
                            <div class="profile-card">
                                <h3>معلوماتي الشخصية</h3>
                                <form action="update_profile.php" method="POST" class="profile-form">
                                    <div class="form-group">
                                        <label for="profileNameInput">الاسم الكامل</label>
                                        <input type="text" id="profileNameInput" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="profilePhoneInput">رقم الهاتف</label>
                                        <input type="tel" id="profilePhoneInput" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required readonly>
                                    </div>
                                    <div class="form-group">
                                        <label for="profileCityInput">المدينة</label>
                                        <select id="profileCityInput" name="city" required>
                                            <option value="الدار البيضاء" <?php echo ($user['city'] === 'الدار البيضاء') ? 'selected' : ''; ?>>الدار البيضاء</option>
                                            <option value="الرباط" <?php echo ($user['city'] === 'الرباط') ? 'selected' : ''; ?>>الرباط</option>
                                            <option value="تمارة" <?php echo ($user['city'] === 'تمارة') ? 'selected' : ''; ?>>تمارة</option>
                                            <option value="المحمدية" <?php echo ($user['city'] === 'المحمدية') ? 'selected' : ''; ?>>المحمدية</option>
                                            <option value="سطات" <?php echo ($user['city'] === 'سطات') ? 'selected' : ''; ?>>سطات</option>
                                            <option value="سلا" <?php echo ($user['city'] === 'سلا') ? 'selected' : ''; ?>>سلا</option>
                                            <option value="القنيطرة" <?php echo ($user['city'] === 'القنيطرة') ? 'selected' : ''; ?>>القنيطرة</option>
                                            <option value="الجديدة" <?php echo ($user['city'] === 'الجديدة') ? 'selected' : ''; ?>>الجديدة</option>
                                            <option value="برشيد" <?php echo ($user['city'] === 'برشيد') ? 'selected' : ''; ?>>برشيد</option>
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                </form>
                            </div>

                            <div class="profile-card">
                                <h3>إحصائياتي</h3>
                                <div class="stats-list">
                                    <div class="stat-item">
                                        <span class="stat-label">الخرجات المكتملة</span>
                                        <span class="stat-value"><?php echo $userRidesCount; ?></span>
                                    </div>
                                    <div class="stat-item">
                                        <span class="stat-label">المسافة المقطوعة</span>
                                        <span class="stat-value">0 كم</span>
                                    </div>
                                    <div class="stat-item">
                                        <span class="stat-label">نقاط الخبرة</span>
                                        <span class="stat-value">100</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </section>
        </div>
    </main>
</div>

<?php require_once 'includes/dashboard_footer.php'; ?>
