<?php

use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\NotificationsController as AdminNotificationsController;
use App\Http\Controllers\Admin\ReviewsController as AdminReviewsController;
use App\Http\Controllers\Admin\SettingsController as AdminSettingsController;
use App\Http\Controllers\Admin\TripsController as AdminTripsController;
use App\Http\Controllers\Admin\UsersController as AdminUsersController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\TripController;
use App\Http\Controllers\TripReviewController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('landing');
})->name('landing');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

Route::middleware(['auth'])->group(function () {
    Route::get('/trips', [TripController::class, 'index'])->name('trips.index');
    Route::get('/trips/create', [TripController::class, 'create'])->name('trips.create');
    Route::post('/trips', [TripController::class, 'store'])->name('trips.store');
    Route::get('/trips/{trip}', [TripController::class, 'show'])->name('trips.show');
    Route::get('/trips/{trip}/edit', [TripController::class, 'edit'])->name('trips.edit');
    Route::put('/trips/{trip}', [TripController::class, 'update'])->name('trips.update');
    Route::delete('/trips/{trip}', [TripController::class, 'destroy'])->name('trips.destroy');

    Route::post('/trips/{trip}/join', [TripController::class, 'join'])->name('trips.join');
    Route::post('/trips/{trip}/leave', [TripController::class, 'leave'])->name('trips.leave');
    Route::post('/trips/{trip}/reviews', [TripReviewController::class, 'store'])->name('trips.reviews.store');

    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
    Route::post('/notifications/{notification}/read', [NotificationController::class, 'markAsRead'])->name('notifications.read');
    Route::view('/wallet', 'wallet.index')->name('wallet.index');
    Route::view('/settings', 'settings.index')->name('settings.index');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');

    Route::get('/users', [AdminUsersController::class, 'index'])->name('users.index');
    Route::get('/users/{user}', [AdminUsersController::class, 'show'])->name('users.show');
    Route::post('/users/{user}/activate', [AdminUsersController::class, 'activate'])->name('users.activate');
    Route::post('/users/{user}/deactivate', [AdminUsersController::class, 'deactivate'])->name('users.deactivate');
    Route::post('/users/{user}/role', [AdminUsersController::class, 'updateRole'])->name('users.role');

    Route::get('/trips', [AdminTripsController::class, 'index'])->name('trips.index');
    Route::get('/trips/create', [AdminTripsController::class, 'create'])->name('trips.create');
    Route::post('/trips', [AdminTripsController::class, 'store'])->name('trips.store');
    Route::get('/trips/{trip}/edit', [AdminTripsController::class, 'edit'])->name('trips.edit');
    Route::put('/trips/{trip}', [AdminTripsController::class, 'update'])->name('trips.update');
    Route::delete('/trips/{trip}', [AdminTripsController::class, 'destroy'])->name('trips.destroy');

    Route::get('/reviews', [AdminReviewsController::class, 'index'])->name('reviews.index');
    Route::delete('/reviews/{review}', [AdminReviewsController::class, 'destroy'])->name('reviews.destroy');

    Route::get('/notifications', [AdminNotificationsController::class, 'index'])->name('notifications.index');
    Route::post('/notifications', [AdminNotificationsController::class, 'store'])->name('notifications.store');

    Route::get('/settings', [AdminSettingsController::class, 'index'])->name('settings.index');
    Route::put('/settings', [AdminSettingsController::class, 'update'])->name('settings.update');
});

require __DIR__.'/auth.php';
