<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">تفاصيل النزهة</h2>
    </x-slot>

    <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
                <div class="lg:col-span-1">
                    @include('layouts.account-sidebar')
                </div>

                <div class="lg:col-span-3 space-y-4">
                    <div class="bg-white border rounded-lg p-6">
                        <div class="flex items-start justify-between gap-4">
                            <div>
                                <div class="font-semibold text-gray-900">{{ $trip->title }}</div>
                                <div class="text-sm text-gray-600 mt-1">
                                    {{ optional($trip->starts_at)->format('Y-m-d H:i') }}
                                    | الحالة: {{ $trip->status }}
                                    | المنظم: {{ optional($trip->creator)->name }}
                                </div>
                            </div>
                            <div class="flex gap-2">
                                @if($isJoined)
                                    <form method="POST" action="{{ route('trips.leave', $trip) }}">
                                        @csrf
                                        <button class="px-4 py-2 rounded border">انسحاب</button>
                                    </form>
                                @else
                                    <form method="POST" action="{{ route('trips.join', $trip) }}">
                                        @csrf
                                        <button class="px-4 py-2 rounded bg-black text-white">انضم</button>
                                    </form>
                                @endif

                                @if($canEdit)
                                    <a href="{{ route('trips.edit', $trip) }}" class="px-4 py-2 rounded border">تعديل</a>
                                @endif
                            </div>
                        </div>

                        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="border rounded p-4">
                                <div class="text-sm text-gray-600">التاريخ والوقت</div>
                                <div class="font-semibold">{{ optional($trip->starts_at)->format('Y-m-d H:i') }}</div>
                            </div>
                            <div class="border rounded p-4">
                                <div class="text-sm text-gray-600">عدد المشاركين</div>
                                <div class="font-semibold">{{ $trip->joined_participants_count ?? 0 }}@if($trip->max_participants) / {{ $trip->max_participants }}@endif</div>
                            </div>
                        </div>

                        <div class="mt-4 border rounded p-4">
                            <div class="text-sm text-gray-600">المسار</div>
                            <div class="mt-1 text-gray-900">{{ $trip->route ?? '-' }}</div>
                        </div>

                        <div class="mt-4 border rounded p-4">
                            <div class="text-sm text-gray-600">نقطة التجمع</div>
                            <div class="mt-1 text-gray-900">{{ $trip->meeting_point ?? '-' }}</div>
                        </div>

                        <div class="mt-4 border rounded p-4">
                            <div class="text-sm text-gray-600">الوصف</div>
                            <div class="mt-1 text-gray-900">{{ $trip->description ?? '-' }}</div>
                        </div>
                    </div>

                    <div class="bg-white border rounded-lg p-6 space-y-3">
                        <div class="font-semibold">التقييمات والتعليقات</div>

                        @if($trip->status !== 'completed')
                            <div class="text-gray-700">يمكن التقييم بعد انتهاء النزهة.</div>
                        @else
                            <form method="POST" action="{{ route('trips.reviews.store', $trip) }}" class="space-y-3">
                                @csrf

                                <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                                    <div>
                                        <label class="block text-sm text-gray-700 mb-1">التقييم (1-5)</label>
                                        <select name="rating" class="w-full border rounded p-2" required>
                                            @for($i = 1; $i <= 5; $i++)
                                                <option value="{{ $i }}" @selected((int)old('rating', optional($myReview)->rating) === $i)>{{ $i }}</option>
                                            @endfor
                                        </select>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-sm text-gray-700 mb-1">تعليق</label>
                                    <textarea name="comment" class="w-full border rounded p-2" rows="3">{{ old('comment', optional($myReview)->comment) }}</textarea>
                                </div>

                                <button class="px-4 py-2 rounded bg-black text-white">حفظ التقييم</button>
                            </form>
                        @endif

                        <div class="border-t pt-4">
                            @if($reviews->count() === 0)
                                <div class="text-gray-700">لا توجد تقييمات بعد.</div>
                            @else
                                <div class="space-y-3">
                                    @foreach($reviews as $r)
                                        <div class="border rounded p-4">
                                            <div class="flex justify-between text-sm text-gray-600">
                                                <div>{{ optional($r->user)->name }}</div>
                                                <div>{{ optional($r->created_at)->format('Y-m-d H:i') }}</div>
                                            </div>
                                            <div class="mt-2 font-semibold">التقييم: {{ $r->rating }}/5</div>
                                            @if($r->comment)
                                                <div class="mt-2 text-gray-800">{{ $r->comment }}</div>
                                            @endif
                                        </div>
                                    @endforeach
                                </div>

                                <div class="mt-4">
                                    {{ $reviews->links() }}
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="bg-white border rounded-lg p-6">
                        <a href="{{ route('trips.index') }}" class="underline">العودة إلى الخرجات</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
