<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">الخرجات القادمة</h2>
    </x-slot>

    <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
                <div class="lg:col-span-1">
                    @include('layouts.account-sidebar')
                </div>

                <div class="lg:col-span-3 space-y-4">
                    <div class="bg-white border rounded-lg p-4 flex flex-col sm:flex-row gap-3 sm:items-center sm:justify-between">
                        <div>
                            <div class="font-semibold text-gray-900">الخرجات</div>
                            <div class="text-sm text-gray-600">بحث/تصفية + قائمة الخرجات القادمة.</div>
                        </div>
                        <div class="flex gap-2">
                            <a href="{{ route('trips.create') }}" class="px-4 py-2 rounded bg-black text-white">إنشاء نزهة</a>
                        </div>
                    </div>

                    <div class="bg-white border rounded-lg p-4">
                        <div class="font-semibold">بحث وتصفية</div>
                        <form method="GET" action="{{ route('trips.index') }}" class="mt-3 grid grid-cols-1 md:grid-cols-4 gap-3">
                            <input name="q" class="border rounded p-2" placeholder="بحث بالاسم أو الوجهة" value="{{ $filters['q'] ?? '' }}">
                            <input name="date" type="date" class="border rounded p-2" value="{{ $filters['date'] ?? '' }}">
                            <select name="status" class="border rounded p-2">
                                <option value="">-- الحالة --</option>
                                <option value="scheduled" @selected(($filters['status'] ?? '') === 'scheduled')>scheduled</option>
                                <option value="completed" @selected(($filters['status'] ?? '') === 'completed')>completed</option>
                                <option value="cancelled" @selected(($filters['status'] ?? '') === 'cancelled')>cancelled</option>
                            </select>
                            <button class="px-4 py-2 rounded bg-gray-900 text-white">بحث</button>
                        </form>
                    </div>

                    <div class="bg-white border rounded-lg overflow-hidden">
                        <div class="p-4 border-b font-semibold">قائمة الخرجات</div>
                        <div class="p-4">
                            @if($trips->count() === 0)
                                <div class="text-gray-700">لا توجد خرجات مطابقة.</div>
                            @else
                                <div class="space-y-3">
                                    @foreach($trips as $trip)
                                        <div class="border rounded p-4 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
                                            <div class="space-y-1">
                                                <div class="font-semibold text-gray-900">
                                                    <a class="underline" href="{{ route('trips.show', $trip) }}">{{ $trip->title }}</a>
                                                </div>
                                                <div class="text-sm text-gray-600">
                                                    {{ optional($trip->starts_at)->format('Y-m-d H:i') }}
                                                    | الحالة: {{ $trip->status }}
                                                    | المشاركون: {{ $trip->joined_participants_count ?? 0 }}@if($trip->max_participants) / {{ $trip->max_participants }}@endif
                                                </div>
                                                <div class="text-sm text-gray-600">المنظم: {{ optional($trip->creator)->name }}</div>
                                            </div>

                                            <div class="flex flex-wrap gap-2">
                                                @php $joined = in_array($trip->id, $joinedTripIds ?? [], true); @endphp

                                                @if($joined)
                                                    <form method="POST" action="{{ route('trips.leave', $trip) }}">
                                                        @csrf
                                                        <button class="px-4 py-2 rounded border">انسحاب</button>
                                                    </form>
                                                @else
                                                    <form method="POST" action="{{ route('trips.join', $trip) }}">
                                                        @csrf
                                                        <button class="px-4 py-2 rounded bg-black text-white">انضم</button>
                                                    </form>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="mt-4">
                                    {{ $trips->links() }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
