<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">إنشاء نزهة</h2>
    </x-slot>

    <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
                <div class="lg:col-span-1">
                    @include('layouts.account-sidebar')
                </div>

                <div class="lg:col-span-3">
                    <div class="bg-white border rounded-lg p-6 space-y-4">
                        <div>
                            <div class="font-semibold text-gray-900">بيانات النزهة</div>
                            <div class="text-sm text-gray-600">املأ البيانات لإنشاء نزهة جديدة.</div>
                        </div>

                        <form method="POST" action="{{ route('trips.store') }}" class="space-y-4">
                            @csrf

                            <div>
                                <label class="block text-sm text-gray-700 mb-1">عنوان النزهة</label>
                                <input name="title" class="w-full border rounded p-2" placeholder="مثال: جولة أكادير الساحلية" required value="{{ old('title') }}">
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm text-gray-700 mb-1">تاريخ ووقت الانطلاق</label>
                                    <input name="starts_at" type="datetime-local" class="w-full border rounded p-2" required value="{{ old('starts_at') }}">
                                </div>
                                <div>
                                    <label class="block text-sm text-gray-700 mb-1">عدد المشاركين (حد أقصى)</label>
                                    <input name="max_participants" type="number" min="1" class="w-full border rounded p-2" value="{{ old('max_participants') }}">
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm text-gray-700 mb-1">نقطة التجمع</label>
                                <input name="meeting_point" class="w-full border rounded p-2" value="{{ old('meeting_point') }}">
                            </div>

                            <div>
                                <label class="block text-sm text-gray-700 mb-1">المسار</label>
                                <textarea name="route" class="w-full border rounded p-2" rows="4">{{ old('route') }}</textarea>
                            </div>

                            <div>
                                <label class="block text-sm text-gray-700 mb-1">الوصف</label>
                                <textarea name="description" class="w-full border rounded p-2" rows="4">{{ old('description') }}</textarea>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm text-gray-700 mb-1">الرسوم (بالسنتيم)</label>
                                    <input name="fee_cents" type="number" min="0" class="w-full border rounded p-2" value="{{ old('fee_cents') }}">
                                </div>
                                <div>
                                    <label class="block text-sm text-gray-700 mb-1">العملة</label>
                                    <input name="currency" class="w-full border rounded p-2" value="{{ old('currency', 'MAD') }}">
                                </div>
                            </div>

                            <div class="flex gap-2">
                                <a href="{{ route('trips.index') }}" class="px-4 py-2 rounded border">رجوع</a>
                                <button class="px-4 py-2 rounded bg-black text-white">حفظ</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
