<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">الإشعارات</h2>
    </x-slot>

    <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
                <div class="lg:col-span-1">
                    @include('layouts.account-sidebar')
                </div>

                <div class="lg:col-span-3 space-y-4">
                    <div class="bg-white border rounded-lg p-6">
                        <div class="font-semibold text-gray-900">الإشعارات</div>
                        <div class="text-sm text-gray-600 mt-1">سيتم عرض إشعارات الانضمام/الانسحاب وتحديثات الخرجات هنا.</div>
                    </div>

                    <div class="bg-white border rounded-lg overflow-hidden">
                        <div class="p-4 border-b font-semibold">قائمة الإشعارات</div>
                        <div class="p-4">
                            @if($notifications->count() === 0)
                                <div class="text-gray-700">لا توجد إشعارات بعد.</div>
                            @else
                                <div class="space-y-3">
                                    @foreach($notifications as $n)
                                        <div class="border rounded p-4 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 @if(!$n->read_at) bg-yellow-50 @endif">
                                            <div>
                                                <div class="font-semibold text-gray-900">{{ $n->title }}</div>
                                                <div class="text-sm text-gray-700 mt-1">{{ $n->body }}</div>
                                                <div class="text-xs text-gray-500 mt-2">{{ optional($n->created_at)->format('Y-m-d H:i') }}</div>
                                            </div>

                                            <div class="flex gap-2">
                                                @if(!$n->read_at)
                                                    <form method="POST" action="{{ route('notifications.read', $n) }}">
                                                        @csrf
                                                        <button class="px-4 py-2 rounded bg-gray-900 text-white">تمت القراءة</button>
                                                    </form>
                                                @else
                                                    <div class="text-sm text-gray-600">مقروء</div>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="mt-4">
                                    {{ $notifications->links() }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
