<aside class="bg-white border rounded-lg overflow-hidden">
    <div class="p-4 border-b">
        <div class="font-semibold text-gray-900">الحساب</div>
        <div class="text-sm text-gray-600">{{ auth()->user()?->name }}</div>
    </div>

    <nav class="p-2 space-y-1">
        <a href="{{ route('dashboard') }}"
           class="block px-3 py-2 rounded {{ request()->routeIs('dashboard') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
            لوحة المستخدم
        </a>

        <a href="{{ route('trips.index') }}"
           class="block px-3 py-2 rounded {{ request()->routeIs('trips.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
            الخرجات
        </a>

        <a href="{{ route('notifications.index') }}"
           class="block px-3 py-2 rounded {{ request()->routeIs('notifications.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
            الإشعارات
        </a>

        <a href="{{ route('wallet.index') }}"
           class="block px-3 py-2 rounded {{ request()->routeIs('wallet.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
            المحفظة / الرسوم
        </a>

        <a href="{{ route('settings.index') }}"
           class="block px-3 py-2 rounded {{ request()->routeIs('settings.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
            الإعدادات
        </a>

        <a href="{{ route('profile.edit') }}"
           class="block px-3 py-2 rounded {{ request()->routeIs('profile.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
            الملف الشخصي
        </a>

        @if(auth()->user()?->role === 'admin')
            <a href="{{ route('admin.dashboard') }}"
               class="block px-3 py-2 rounded {{ request()->routeIs('admin.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                لوحة الإدارة
            </a>
        @endif
    </nav>

    <div class="p-4 border-t">
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit" class="w-full px-3 py-2 rounded border text-gray-700 hover:bg-gray-50">تسجيل الخروج</button>
        </form>
    </div>
</aside>
