<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name') }}</title>

    @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    @endif
</head>
<body class="bg-black text-white">
    <div class="min-h-screen">
        <header class="sticky top-0 z-40 bg-black/60 backdrop-blur border-b border-white/10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-16 flex items-center justify-between">
                <a href="#top" class="font-semibold tracking-wide">{{ config('app.name') }}</a>

                <nav class="hidden md:flex items-center gap-6 text-sm text-white/80">
                    <a href="#features" class="hover:text-white">مميزات المنصة</a>
                    <a href="#about" class="hover:text-white">من نحن</a>
                    <a href="#rules" class="hover:text-white">قوانين الخرجات</a>
                </nav>

                <div class="flex items-center gap-2">
                    @if (Route::has('login'))
                        @auth
                            <a href="{{ route('dashboard') }}" class="px-4 py-2 rounded bg-white text-black text-sm">لوحة المستخدم</a>
                        @else
                            <a href="{{ route('login') }}" class="px-4 py-2 rounded border border-white/30 text-sm hover:bg-white hover:text-black">تسجيل الدخول</a>
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}" class="px-4 py-2 rounded bg-yellow-400 text-black text-sm hover:bg-yellow-300">تسجيل</a>
                            @endif
                        @endauth
                    @endif
                </div>
            </div>
        </header>

        <section id="top" class="relative overflow-hidden">
            <div class="absolute inset-0">
                <div class="absolute inset-0 bg-gradient-to-br from-yellow-500/30 via-red-500/20 to-purple-600/30"></div>
                <div class="absolute inset-0 bg-[radial-gradient(circle_at_20%_20%,rgba(255,255,255,0.12),transparent_55%),radial-gradient(circle_at_80%_30%,rgba(255,255,255,0.10),transparent_55%),radial-gradient(circle_at_50%_80%,rgba(255,255,255,0.08),transparent_55%)]"></div>
            </div>

            <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16 lg:py-24">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-10 items-center">
                    <div class="space-y-5">
                        <div class="inline-flex items-center gap-2 text-xs text-white/70 border border-white/15 rounded-full px-3 py-1">
                            <span class="w-2 h-2 rounded-full bg-green-400"></span>
                            خرجات دراجات نارية منظمة
                        </div>

                        <h1 class="text-3xl sm:text-4xl lg:text-5xl font-bold leading-tight">
                            منصة احترافية لإدارة خرجات الدراجات النارية
                        </h1>
                        <p class="text-white/75 leading-7">
                            سجّل حسابك، أنشئ نزهة أو انضم لنزهة، وتتبع التفاصيل والإشعارات مع لوحة إدارة كاملة للمسؤول.
                        </p>

                        <div class="flex flex-wrap gap-3">
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}" class="px-5 py-3 rounded bg-yellow-400 text-black font-semibold hover:bg-yellow-300">ابدأ التسجيل</a>
                            @endif
                            @if (Route::has('login'))
                                <a href="{{ route('login') }}" class="px-5 py-3 rounded border border-white/30 hover:bg-white hover:text-black">تسجيل الدخول</a>
                            @endif
                        </div>

                        <div class="grid grid-cols-2 gap-4 pt-4">
                            <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                                <div class="text-sm font-semibold">إدارة الخرجات</div>
                                <div class="text-xs text-white/70 mt-1">إنشاء/تعديل/حذف + انضمام/انسحاب</div>
                            </div>
                            <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                                <div class="text-sm font-semibold">تفاصيل المسار</div>
                                <div class="text-xs text-white/70 mt-1">المسار + الوقت + المشاركين + ملاحظات</div>
                            </div>
                        </div>
                    </div>

                    <div class="relative">
                        <div class="rounded-2xl border border-white/10 bg-white/5 overflow-hidden">
                            <div class="p-4 border-b border-white/10 text-sm text-white/70">صورة دراجات نارية (يمكنك استبدالها لاحقاً)</div>
                            <div class="aspect-[16/10] bg-gradient-to-br from-white/10 to-white/0 flex items-center justify-center text-white/50">
                                ضع صورة داخل public/images
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="features" class="py-16 bg-black">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <div class="lg:col-span-1">
                        <h2 class="text-2xl font-bold">مميزات المنصة</h2>
                        <p class="text-white/70 mt-2 leading-7">منصة لإدارة خرجات الدراجات: تخطيط، مشاركة، إشعارات، وتقييمات بعد نهاية النزهة.</p>
                    </div>
                    <div class="lg:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="rounded-lg border border-white/10 bg-white/5 p-6">
                            <div class="font-semibold">تنظيم احترافي</div>
                            <div class="text-white/70 text-sm mt-2">إدارة كاملة للخرجات والمشاركين.</div>
                        </div>
                        <div class="rounded-lg border border-white/10 bg-white/5 p-6">
                            <div class="font-semibold">قوانين واضحة</div>
                            <div class="text-white/70 text-sm mt-2">قواعد سلامة ومسؤوليات أثناء الخرجات.</div>
                        </div>
                        <div class="rounded-lg border border-white/10 bg-white/5 p-6">
                            <div class="font-semibold">تقييمات وتعليقات</div>
                            <div class="text-white/70 text-sm mt-2">بعد انتهاء النزهة لتطوير التجربة.</div>
                        </div>
                        <div class="rounded-lg border border-white/10 bg-white/5 p-6">
                            <div class="font-semibold">لوحة مسؤول</div>
                            <div class="text-white/70 text-sm mt-2">إحصائيات + رحلات + مستخدمين + إشعارات.</div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="about" class="py-16 bg-gradient-to-b from-black to-zinc-950">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="rounded-2xl border border-white/10 bg-white/5 p-8">
                    <h2 class="text-2xl font-bold">من نحن</h2>
                    <p class="text-white/70 mt-3 leading-7">اكتب هنا تعريفاً عن فريق التنظيم وخبرة الإدارة (سأضيفه عندما ترسل المحتوى).</p>
                </div>
            </div>
        </section>

        <section id="rules" class="py-16 bg-black">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="rounded-2xl border border-white/10 bg-white/5 p-8">
                    <h2 class="text-2xl font-bold">قوانين الخرجات</h2>
                    <div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4 text-sm text-white/75">
                        <div class="rounded-lg border border-white/10 bg-black/30 p-4">الالتزام بقواعد السلامة واحترام المجموعة</div>
                        <div class="rounded-lg border border-white/10 bg-black/30 p-4">الالتزام بوقت الانطلاق والمسار</div>
                        <div class="rounded-lg border border-white/10 bg-black/30 p-4">التقييم بعد النزهة لتحسين التنظيم</div>
                    </div>
                </div>
            </div>
        </section>

        <footer class="py-10 border-t border-white/10 bg-black">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row gap-3 justify-between text-sm text-white/60">
                <div>© {{ date('Y') }} {{ config('app.name') }}</div>
                <div class="flex gap-4">
                    <a href="#top" class="hover:text-white">الرئيسية</a>
                    <a href="#features" class="hover:text-white">المميزات</a>
                    <a href="#about" class="hover:text-white">من نحن</a>
                </div>
            </div>
        </footer>
    </div>
</body>
</html>
