<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            لوحة المستخدم
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
                <div class="lg:col-span-1">
                    @include('layouts.account-sidebar')
                </div>

                <div class="lg:col-span-3 space-y-6">
                    @if ($errors->any())
                        <div class="bg-red-50 border border-red-200 text-red-800 p-4 rounded">
                            <ul class="list-disc list-inside">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6 text-gray-900 space-y-3">
                            <div class="font-semibold">الحالة</div>

                            <div>
                                المستخدم: <b>{{ auth()->user()?->name }}</b>
                                | الدور: <b>{{ auth()->user()?->role }}</b>
                                | التفعيل: <b>{{ auth()->user()?->is_active ? 'مفعل' : 'غير مفعل' }}</b>
                            </div>

                            <div class="text-gray-700">يمكنك الآن تصفح الخرجات القادمة، أو إنشاء/الانضمام إلى نزهة.</div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                            <div class="p-6 text-gray-900 space-y-4">
                                <div class="font-semibold">خرجات النزهة</div>

                                <div class="text-gray-700">تصفح الخرجات القادمة، اعرض التفاصيل، وانضم أو انسحب.</div>

                                <div class="flex flex-wrap gap-2">
                                    <a href="{{ route('trips.index') }}" class="px-4 py-2 bg-black text-white rounded">عرض الخرجات</a>
                                    <a href="{{ route('trips.create') }}" class="px-4 py-2 border rounded">إنشاء نزهة</a>
                                </div>
                            </div>
                        </div>

                        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                            <div class="p-6 text-gray-900 space-y-3">
                                <div class="font-semibold">إشعارات</div>

                                <div class="text-gray-700">تابع إشعارات الانضمام والتغييرات على الخرجات.</div>

                                <div>
                                    <a href="{{ route('notifications.index') }}" class="underline">فتح الإشعارات</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
