@extends('admin.layout')

@section('title', 'تفاصيل المستخدم')
@section('header', 'تفاصيل المستخدم')

@section('content')
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="bg-white rounded border p-4 space-y-2">
            <div class="font-semibold">بيانات المستخدم</div>
            <div>الاسم: <b>{{ $user->name }}</b></div>
            <div>البريد: <b>{{ $user->email }}</b></div>
            <div>الدور: <b>{{ $user->role }}</b></div>
            <div>التفعيل: <b>{{ $user->is_active ? 'مفعل' : 'غير مفعل' }}</b></div>
            <div>الهاتف: <b>{{ $user->phone ?? '-' }}</b></div>

            <div class="pt-3 border-t space-y-3">
                <div class="font-semibold">إجراءات</div>

                <div class="flex flex-wrap gap-2">
                    @if($user->is_active)
                        <form method="POST" action="{{ route('admin.users.deactivate', $user) }}">
                            @csrf
                            <button class="px-3 py-2 bg-red-600 text-white rounded">تعطيل</button>
                        </form>
                    @else
                        <form method="POST" action="{{ route('admin.users.activate', $user) }}">
                            @csrf
                            <button class="px-3 py-2 bg-green-700 text-white rounded">تفعيل</button>
                        </form>
                    @endif
                </div>

                <form method="POST" action="{{ route('admin.users.role', $user) }}" class="space-y-2">
                    @csrf
                    <label class="block text-sm">تغيير الدور</label>
                    <div class="flex gap-2">
                        <select name="role" class="border rounded p-2">
                            <option value="user" @selected($user->role === 'user')>user</option>
                            <option value="admin" @selected($user->role === 'admin')>admin</option>
                        </select>
                        <button class="px-3 py-2 bg-black text-white rounded">حفظ</button>
                    </div>
                </form>
            </div>
        </div>

        <div class="bg-white rounded border p-4 space-y-2 lg:col-span-2">
            <div class="font-semibold">معلومات إضافية</div>
            <div class="text-gray-700">سيتم لاحقاً عرض المشاركات في الخرجات والتقييمات الخاصة بالمستخدم.</div>
        </div>
    </div>
@endsection
