@extends('admin.layout')

@section('title', 'المستخدمون')
@section('header', 'إدارة المستخدمين')

@section('content')
    <div class="bg-white rounded border overflow-hidden">
        <div class="p-4 border-b flex justify-between items-center">
            <div class="font-semibold">المستخدمون</div>
            <div class="text-sm text-gray-600">الإجمالي: {{ $users->total() }}</div>
        </div>
        <div class="p-4 space-y-4">
            <form method="GET" action="{{ route('admin.users.index') }}" class="flex gap-2">
                <input name="q" class="border rounded p-2 flex-1" placeholder="بحث بالاسم أو البريد" value="{{ $q ?? '' }}">
                <button class="px-4 py-2 rounded bg-gray-900 text-white">بحث</button>
            </form>

            @if($users->count() === 0)
                <div class="text-gray-700">لا يوجد مستخدمون.</div>
            @else
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b text-right">
                            <th class="py-2">#</th>
                            <th>الاسم</th>
                            <th>البريد</th>
                            <th>الدور</th>
                            <th>التفعيل</th>
                            <th class="text-left">عرض</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $u)
                            <tr class="border-b">
                                <td class="py-2">{{ $u->id }}</td>
                                <td>{{ $u->name }}</td>
                                <td>{{ $u->email }}</td>
                                <td>{{ $u->role }}</td>
                                <td>{{ $u->is_active ? 'مفعل' : 'غير مفعل' }}</td>
                                <td class="text-left"><a class="underline" href="{{ route('admin.users.show', $u) }}">فتح</a></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-4">
                    {{ $users->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection
