@extends('admin.layout')

@section('title', 'الخرجات')
@section('header', 'إدارة الخرجات')

@section('content')
    <div class="bg-white rounded border overflow-hidden">
        <div class="p-4 border-b flex flex-col md:flex-row gap-3 md:items-center md:justify-between">
            <div>
                <div class="font-semibold">الخرجات</div>
                <div class="text-sm text-gray-600">الإجمالي: {{ $trips->total() }}</div>
            </div>

            <div class="flex gap-2">
                <a href="{{ route('admin.trips.create') }}" class="px-4 py-2 rounded bg-gray-900 text-white">إضافة نزهة</a>
            </div>
        </div>

        <div class="p-4 space-y-4">
            <form method="GET" action="{{ route('admin.trips.index') }}" class="flex gap-2">
                <input name="q" class="border rounded p-2 flex-1" placeholder="بحث بالعنوان" value="{{ $q ?? '' }}">
                <button class="px-4 py-2 rounded bg-gray-900 text-white">بحث</button>
            </form>

            @if($trips->count() === 0)
                <div class="text-gray-700">لا توجد خرجات.</div>
            @else
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b text-right">
                            <th class="py-2">#</th>
                            <th>العنوان</th>
                            <th>الوقت</th>
                            <th>الحالة</th>
                            <th class="text-left">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($trips as $t)
                            <tr class="border-b">
                                <td class="py-2">{{ $t->id }}</td>
                                <td>{{ $t->title }}</td>
                                <td>{{ optional($t->starts_at)->format('Y-m-d H:i') }}</td>
                                <td>{{ $t->status }}</td>
                                <td class="text-left">
                                    <div class="flex gap-2 justify-start">
                                        <a class="underline" href="{{ route('admin.trips.edit', $t) }}">تعديل</a>
                                        <form method="POST" action="{{ route('admin.trips.destroy', $t) }}" onsubmit="return confirm('حذف النزهة؟')">
                                            @csrf
                                            @method('DELETE')
                                            <button class="underline text-red-700" type="submit">حذف</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-4">
                    {{ $trips->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection
