@extends('admin.layout')

@section('title', 'تعديل نزهة')
@section('header', 'تعديل نزهة')

@section('content')
    <div class="bg-white rounded border p-6 space-y-4">
        <form method="POST" action="{{ route('admin.trips.update', $trip) }}" class="space-y-4">
            @csrf
            @method('PUT')

            <div>
                <label class="block text-sm text-gray-700 mb-1">عنوان النزهة</label>
                <input name="title" class="w-full border rounded p-2" value="{{ old('title', $trip->title) }}" required>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1">تاريخ ووقت الانطلاق</label>
                    <input name="starts_at" type="datetime-local" class="w-full border rounded p-2" value="{{ old('starts_at', optional($trip->starts_at)->format('Y-m-d\TH:i')) }}" required>
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1">حد المشاركين</label>
                    <input name="max_participants" type="number" min="1" class="w-full border rounded p-2" value="{{ old('max_participants', $trip->max_participants) }}">
                </div>
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">نقطة التجمع</label>
                <input name="meeting_point" class="w-full border rounded p-2" value="{{ old('meeting_point', $trip->meeting_point) }}">
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">المسار</label>
                <textarea name="route" class="w-full border rounded p-2" rows="4">{{ old('route', $trip->route) }}</textarea>
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">الوصف</label>
                <textarea name="description" class="w-full border rounded p-2" rows="4">{{ old('description', $trip->description) }}</textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1">الحالة</label>
                    <select name="status" class="w-full border rounded p-2" required>
                        <option value="scheduled" @selected(old('status', $trip->status) === 'scheduled')>scheduled</option>
                        <option value="completed" @selected(old('status', $trip->status) === 'completed')>completed</option>
                        <option value="cancelled" @selected(old('status', $trip->status) === 'cancelled')>cancelled</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1">الرسوم (بالسنتيم)</label>
                    <input name="fee_cents" type="number" min="0" class="w-full border rounded p-2" value="{{ old('fee_cents', $trip->fee_cents) }}">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1">العملة</label>
                    <input name="currency" class="w-full border rounded p-2" value="{{ old('currency', $trip->currency) }}">
                </div>
            </div>

            <div class="flex flex-wrap gap-2">
                <a href="{{ route('admin.trips.index') }}" class="px-4 py-2 rounded border">رجوع</a>
                <button class="px-4 py-2 rounded bg-gray-900 text-white">حفظ</button>
            </div>
        </form>

        <form method="POST" action="{{ route('admin.trips.destroy', $trip) }}" onsubmit="return confirm('حذف النزهة؟')">
            @csrf
            @method('DELETE')
            <button class="px-4 py-2 rounded bg-red-600 text-white">حذف النزهة</button>
        </form>
    </div>
@endsection
