@extends('admin.layout')

@section('title', 'إضافة نزهة')
@section('header', 'إضافة نزهة')

@section('content')
    <div class="bg-white rounded border p-6 space-y-4">
        <form method="POST" action="{{ route('admin.trips.store') }}" class="space-y-4">
            @csrf

            <div>
                <label class="block text-sm text-gray-700 mb-1">عنوان النزهة</label>
                <input name="title" class="w-full border rounded p-2" value="{{ old('title') }}" required>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1">تاريخ ووقت الانطلاق</label>
                    <input name="starts_at" type="datetime-local" class="w-full border rounded p-2" value="{{ old('starts_at') }}" required>
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1">حد المشاركين</label>
                    <input name="max_participants" type="number" min="1" class="w-full border rounded p-2" value="{{ old('max_participants') }}">
                </div>
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">نقطة التجمع</label>
                <input name="meeting_point" class="w-full border rounded p-2" value="{{ old('meeting_point') }}">
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">المسار</label>
                <textarea name="route" class="w-full border rounded p-2" rows="4">{{ old('route') }}</textarea>
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">الوصف</label>
                <textarea name="description" class="w-full border rounded p-2" rows="4">{{ old('description') }}</textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1">الرسوم (بالسنتيم)</label>
                    <input name="fee_cents" type="number" min="0" class="w-full border rounded p-2" value="{{ old('fee_cents') }}">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1">العملة</label>
                    <input name="currency" class="w-full border rounded p-2" value="{{ old('currency', 'MAD') }}">
                </div>
            </div>

            <div class="flex gap-2">
                <a href="{{ route('admin.trips.index') }}" class="px-4 py-2 rounded border">رجوع</a>
                <button class="px-4 py-2 rounded bg-gray-900 text-white">حفظ</button>
            </div>
        </form>
    </div>
@endsection
