@extends('admin.layout')

@section('title', 'الإعدادات')
@section('header', 'إعدادات المنصة')

@section('content')
    <div class="bg-white rounded border p-4 space-y-4">
        <div class="font-semibold">إعدادات عامة</div>

        <form method="POST" action="{{ route('admin.settings.update') }}" class="space-y-4">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1">اسم المنصة</label>
                    <input name="platform_name" class="w-full border rounded p-2" value="{{ old('platform_name', $settings['platform_name'] ?? config('app.name')) }}">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1">الشعار</label>
                    <input class="w-full border rounded p-2" value="(قريباً)" disabled>
                </div>
            </div>

            <div>
                <label class="block text-sm text-gray-700 mb-1">قوانين الخرجات</label>
                <textarea name="rules" class="w-full border rounded p-2" rows="6">{{ old('rules', $settings['rules'] ?? '') }}</textarea>
            </div>

            <button class="px-4 py-2 rounded bg-gray-900 text-white">حفظ</button>
        </form>
    </div>
@endsection
