@extends('admin.layout')

@section('title', 'التقييمات')
@section('header', 'إدارة التقييمات والتعليقات')

@section('content')
    <div class="bg-white rounded border overflow-hidden">
        <div class="p-4 border-b flex justify-between items-center">
            <div class="font-semibold">التقييمات</div>
            <div class="text-sm text-gray-600">الإجمالي: {{ $reviews->total() }}</div>
        </div>

        <div class="p-4">
            @if($reviews->count() === 0)
                <div class="text-gray-700">لا توجد تقييمات.</div>
            @else
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b text-right">
                            <th class="py-2">#</th>
                            <th>الرحلة</th>
                            <th>المستخدم</th>
                            <th>التقييم</th>
                            <th>التعليق</th>
                            <th class="text-left">حذف</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($reviews as $r)
                            <tr class="border-b">
                                <td class="py-2">{{ $r->id }}</td>
                                <td>{{ optional($r->trip)->title }}</td>
                                <td>{{ optional($r->user)->name }}</td>
                                <td>{{ $r->rating }}/5</td>
                                <td class="max-w-md">{{ $r->comment }}</td>
                                <td class="text-left">
                                    <form method="POST" action="{{ route('admin.reviews.destroy', $r) }}" onsubmit="return confirm('حذف التقييم؟')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="underline text-red-700" type="submit">حذف</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-4">
                    {{ $reviews->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection
