@extends('admin.layout')

@section('title', 'الإشعارات')
@section('header', 'إدارة الإشعارات')

@section('content')
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="bg-white rounded border p-4 space-y-3">
            <div class="font-semibold">إنشاء إشعار</div>

            <form method="POST" action="{{ route('admin.notifications.store') }}" class="space-y-3">
                @csrf

                <div>
                    <label class="block text-sm text-gray-700 mb-1">User ID (اختياري)</label>
                    <input name="user_id" class="w-full border rounded p-2" value="{{ old('user_id') }}" placeholder="اتركه فارغاً لإرسال عام">
                </div>

                <div>
                    <label class="block text-sm text-gray-700 mb-1">العنوان</label>
                    <input name="title" class="w-full border rounded p-2" value="{{ old('title') }}" required>
                </div>

                <div>
                    <label class="block text-sm text-gray-700 mb-1">المحتوى</label>
                    <textarea name="body" class="w-full border rounded p-2" rows="4" required>{{ old('body') }}</textarea>
                </div>

                <button class="px-4 py-2 rounded bg-gray-900 text-white">إرسال</button>
            </form>
        </div>

        <div class="bg-white rounded border overflow-hidden lg:col-span-2">
            <div class="p-4 border-b flex justify-between items-center">
                <div class="font-semibold">قائمة الإشعارات</div>
                <div class="text-sm text-gray-600">الإجمالي: {{ $notifications->total() }}</div>
            </div>

            <div class="p-4">
                @if($notifications->count() === 0)
                    <div class="text-gray-700">لا توجد إشعارات.</div>
                @else
                    <div class="space-y-3">
                        @foreach($notifications as $n)
                            <div class="border rounded p-4">
                                <div class="flex justify-between text-sm text-gray-600">
                                    <div>user_id: {{ $n->user_id ?? 'all' }}</div>
                                    <div>{{ optional($n->created_at)->format('Y-m-d H:i') }}</div>
                                </div>
                                <div class="mt-2 font-semibold">{{ $n->title }}</div>
                                <div class="mt-1 text-gray-800">{{ $n->body }}</div>
                            </div>
                        @endforeach
                    </div>

                    <div class="mt-4">
                        {{ $notifications->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
