<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', config('app.name'))</title>

    @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    @endif
</head>
<body class="min-h-screen bg-gray-100">
    <div class="min-h-screen flex">
        <aside class="w-72 bg-white border-l hidden md:flex md:flex-col">
            <div class="h-16 flex items-center px-6 border-b">
                <a href="{{ route('admin.dashboard') }}" class="font-semibold text-gray-900">لوحة الإدارة</a>
            </div>

            <nav class="p-4 space-y-1">
                <a href="{{ route('admin.dashboard') }}" class="block px-3 py-2 rounded {{ request()->routeIs('admin.dashboard') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">الإحصائيات</a>
                <a href="{{ route('admin.users.index') }}" class="block px-3 py-2 rounded {{ request()->routeIs('admin.users.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">الأعضاء</a>
                <a href="{{ route('admin.trips.index') }}" class="block px-3 py-2 rounded {{ request()->routeIs('admin.trips.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">الخرجات</a>
                <a href="{{ route('admin.reviews.index') }}" class="block px-3 py-2 rounded {{ request()->routeIs('admin.reviews.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">التقييمات</a>
                <a href="{{ route('admin.notifications.index') }}" class="block px-3 py-2 rounded {{ request()->routeIs('admin.notifications.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">الإشعارات</a>
                <a href="{{ route('admin.settings.index') }}" class="block px-3 py-2 rounded {{ request()->routeIs('admin.settings.*') ? 'bg-gray-900 text-white' : 'text-gray-700 hover:bg-gray-100' }}">الإعدادات</a>
            </nav>

            <div class="mt-auto p-4 border-t text-sm text-gray-600">
                {{ config('app.name') }}
            </div>
        </aside>

        <div class="flex-1 flex flex-col">
            <header class="h-16 bg-white border-b flex items-center justify-between px-4 sm:px-6">
                <div class="font-semibold text-gray-900">@yield('header', 'لوحة الإدارة')</div>

                <div class="flex items-center gap-3">
                    <a href="{{ route('dashboard') }}" class="text-sm text-gray-700 hover:underline">لوحة المستخدم</a>

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button class="text-sm text-gray-700 hover:underline" type="submit">تسجيل الخروج</button>
                    </form>
                </div>
            </header>

            <main class="flex-1 p-4 sm:p-6">
                @if ($errors->any())
                    <div class="mb-4 bg-red-50 border border-red-200 text-red-800 p-4 rounded">
                        <ul class="list-disc list-inside">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @yield('content')
            </main>
        </div>
    </div>
</body>
</html>
