@extends('admin.layout')

@section('title', 'لوحة الإدارة')
@section('header', 'لوحة الإدارة')

@section('content')
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white rounded border p-4">
            <div class="text-sm text-gray-600">المستخدمون</div>
            <div class="text-2xl font-semibold">{{ $stats['users'] ?? 0 }}</div>
        </div>
        <div class="bg-white rounded border p-4">
            <div class="text-sm text-gray-600">الخرجات</div>
            <div class="text-2xl font-semibold">{{ $stats['trips'] ?? 0 }}</div>
        </div>
        <div class="bg-white rounded border p-4">
            <div class="text-sm text-gray-600">النشطة</div>
            <div class="text-2xl font-semibold">{{ $stats['active_trips'] ?? 0 }}</div>
        </div>
        <div class="bg-white rounded border p-4">
            <div class="text-sm text-gray-600">المشاركات</div>
            <div class="text-2xl font-semibold">{{ $stats['participations'] ?? 0 }}</div>
        </div>
    </div>

    <div class="mt-6 bg-white rounded border p-4">
        <div class="font-semibold">ملاحظات</div>
        <div class="text-gray-700 mt-2">التقييمات: {{ $stats['reviews'] ?? 0 }}</div>
    </div>
@endsection
