<?php

namespace Database\Seeders;

use App\Models\AppSetting;
use App\Models\Trip;
use App\Models\TripParticipant;
use App\Models\TripReview;
use App\Models\UserNotification;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $admin = User::query()->firstOrCreate(
            ['email' => 'admin@ridemorocco.local'],
            [
                'name' => 'Admin',
                'password' => Hash::make('password'),
                'role' => 'admin',
                'is_active' => true,
            ]
        );

        User::query()->firstOrCreate(
            ['email' => 'user@ridemorocco.local'],
            [
                'name' => 'User',
                'password' => Hash::make('password'),
                'role' => 'user',
                'is_active' => true,
            ]
        );

        $users = User::factory(10)->create();

        AppSetting::query()->updateOrCreate(
            ['key' => 'platform_name'],
            ['value' => 'Ride Morocco']
        );
        AppSetting::query()->updateOrCreate(
            ['key' => 'rules'],
            ['value' => "- ارتداء الخوذة إلزامي\n- احترام السرعة\n- الالتزام بوقت الانطلاق"]
        );

        $trip1 = Trip::query()->create([
            'created_by' => $admin->id,
            'title' => 'جولة ساحلية',
            'description' => 'نزهة صباحية على الساحل.',
            'meeting_point' => 'محطة الوقود الرئيسية',
            'route' => 'نقطة A -> نقطة B -> نقطة C',
            'starts_at' => now()->addDays(2)->setTime(9, 0),
            'max_participants' => 20,
            'status' => 'scheduled',
            'fee_cents' => 0,
            'currency' => 'MAD',
        ]);

        $trip2 = Trip::query()->create([
            'created_by' => $admin->id,
            'title' => 'رحلة جبلية',
            'description' => 'نزهة نحو الجبال والمناظر الطبيعية.',
            'meeting_point' => 'ساحة المدينة',
            'route' => 'المدينة -> الجبل -> العودة',
            'starts_at' => now()->subDays(3)->setTime(8, 30),
            'max_participants' => 15,
            'status' => 'completed',
            'fee_cents' => 5000,
            'currency' => 'MAD',
        ]);

        foreach ($users->take(6) as $u) {
            TripParticipant::query()->updateOrCreate(
                ['trip_id' => $trip1->id, 'user_id' => $u->id],
                ['status' => 'joined', 'joined_at' => now()]
            );
        }

        foreach ($users->take(5) as $u) {
            TripParticipant::query()->updateOrCreate(
                ['trip_id' => $trip2->id, 'user_id' => $u->id],
                ['status' => 'joined', 'joined_at' => now()->subDays(5)]
            );

            TripReview::query()->updateOrCreate(
                ['trip_id' => $trip2->id, 'user_id' => $u->id],
                ['rating' => rand(3, 5), 'comment' => 'تجربة ممتازة!']
            );
        }

        UserNotification::query()->create([
            'user_id' => null,
            'title' => 'أهلاً بك',
            'body' => 'مرحباً بك في منصة إدارة خرجات الدراجات النارية.',
            'data' => ['type' => 'welcome'],
        ]);
    }
}
