<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Trip extends Model
{
    protected $fillable = [
        'created_by',
        'title',
        'description',
        'route',
        'meeting_point',
        'starts_at',
        'max_participants',
        'status',
        'fee_cents',
        'currency',
    ];

    protected $casts = [
        'starts_at' => 'datetime',
        'max_participants' => 'integer',
        'fee_cents' => 'integer',
    ];

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function participants(): HasMany
    {
        return $this->hasMany(TripParticipant::class);
    }

    public function reviews(): HasMany
    {
        return $this->hasMany(TripReview::class);
    }

    public function scopeUpcoming($query)
    {
        return $query->where('starts_at', '>=', now())->where('status', 'scheduled');
    }
}
