<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTripRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() !== null;
    }

    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string'],
            'route' => ['nullable', 'string'],
            'meeting_point' => ['nullable', 'string', 'max:255'],
            'starts_at' => ['required', 'date'],
            'max_participants' => ['nullable', 'integer', 'min:1'],
            'status' => ['required', 'in:scheduled,completed,cancelled'],
            'fee_cents' => ['nullable', 'integer', 'min:0'],
            'currency' => ['nullable', 'string', 'size:3'],
        ];
    }
}
