<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreTripReviewRequest;
use App\Models\Trip;
use App\Models\TripReview;
use Illuminate\Http\RedirectResponse;

class TripReviewController extends Controller
{
    public function store(StoreTripReviewRequest $request, Trip $trip): RedirectResponse
    {
        if ($trip->status !== 'completed') {
            return back()->withErrors(['review' => 'لا يمكن التقييم قبل انتهاء النزهة.']);
        }

        TripReview::query()->updateOrCreate(
            [
                'trip_id' => $trip->id,
                'user_id' => $request->user()->id,
            ],
            [
                'rating' => $request->validated()['rating'],
                'comment' => $request->validated()['comment'] ?? null,
            ]
        );

        return back()->with('status', 'review-saved');
    }
}
