<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AppSetting;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SettingsController extends Controller
{
    public function index(): View
    {
        $settings = AppSetting::query()->pluck('value', 'key')->all();

        return view('admin.settings.index', [
            'settings' => $settings,
        ]);
    }

    public function update(Request $request): RedirectResponse
    {
        $data = $request->validate([
            'platform_name' => ['nullable', 'string', 'max:255'],
            'rules' => ['nullable', 'string'],
        ]);

        foreach (['platform_name', 'rules'] as $key) {
            if (array_key_exists($key, $data)) {
                AppSetting::query()->updateOrCreate(
                    ['key' => $key],
                    ['value' => $data[$key]]
                );
            }
        }

        return back()->with('status', 'settings-updated');
    }
}
