<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TripReview;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ReviewsController extends Controller
{
    public function index(Request $request): View
    {
        $reviews = TripReview::query()
            ->with(['trip', 'user'])
            ->latest()
            ->paginate(20);

        return view('admin.reviews.index', [
            'reviews' => $reviews,
        ]);
    }

    public function destroy(TripReview $review): RedirectResponse
    {
        $review->delete();

        return back()->with('status', 'review-deleted');
    }
}
