<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\UserNotification;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class NotificationsController extends Controller
{
    public function index(): View
    {
        $notifications = UserNotification::query()
            ->latest()
            ->paginate(25);

        return view('admin.notifications.index', [
            'notifications' => $notifications,
        ]);
    }

    public function store(Request $request): RedirectResponse
    {
        $data = $request->validate([
            'user_id' => ['nullable', 'integer', 'exists:users,id'],
            'title' => ['required', 'string', 'max:255'],
            'body' => ['required', 'string'],
        ]);

        UserNotification::create([
            'user_id' => $data['user_id'] ?? null,
            'title' => $data['title'],
            'body' => $data['body'],
            'data' => ['type' => 'admin_broadcast'],
        ]);

        return back()->with('status', 'notification-created');
    }
}
