<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Trip;
use App\Models\TripParticipant;
use App\Models\TripReview;
use App\Models\User;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        $stats = [
            'users' => User::query()->count(),
            'trips' => Trip::query()->count(),
            'active_trips' => Trip::query()->where('status', 'scheduled')->count(),
            'participations' => TripParticipant::query()->where('status', 'joined')->count(),
            'reviews' => TripReview::query()->count(),
        ];

        return view('admin.dashboard', [
            'stats' => $stats,
        ]);
    }
}
