<?php
$page_title = 'الخرجات القادمة';
require_once 'includes/dashboard_header.php';

// Get upcoming rides
$stmt = $pdo->prepare("
    SELECT r.*, 
           COUNT(rp.user_id) as participants_count,
           CASE WHEN rp_user.user_id IS NOT NULL THEN 1 ELSE 0 END as user_joined
    FROM rides r 
    LEFT JOIN ride_participants rp ON r.id = rp.ride_id 
    LEFT JOIN ride_participants rp_user ON r.id = rp_user.ride_id AND rp_user.user_id = ?
    WHERE r.date >= CURDATE() 
    GROUP BY r.id 
    ORDER BY r.date ASC
");
$stmt->execute([$_SESSION['user_id']]);
$upcoming_rides = $stmt->fetchAll();
?>

<div class="dashboard-container">
    <?php include 'includes/dashboard_sidebar.php'; ?>

    <main class="main-content">
        <?php include 'includes/dashboard_topbar.php'; ?>
        
        <div class="content-wrapper">
            <section class="content-section">
    <div class="section-header">
        <h2>الخرجات القادمة</h2>
        <p>انضم إلى مغامرات جديدة واستكشف المغرب</p>
    </div>

    <div class="rides-grid">
        <?php if (empty($upcoming_rides)): ?>
            <div class="empty-state">
                <i class="fas fa-calendar-times"></i>
                <h3>لا توجد خرجات قادمة</h3>
                <p>تابعنا للحصول على آخر التحديثات حول الخرجات الجديدة</p>
            </div>
        <?php else: ?>
            <?php foreach ($upcoming_rides as $ride): ?>
                <div class="ride-card">
                    <div class="ride-header">
                        <h3><?php echo htmlspecialchars($ride['title']); ?></h3>
                        <span class="ride-date">
                            <i class="fas fa-calendar"></i>
                            <?php echo date('d/m/Y', strtotime($ride['date'])); ?>
                        </span>
                    </div>
                    
                    <div class="ride-details">
                        <div class="detail-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <span><?php echo htmlspecialchars($ride['location']); ?></span>
                        </div>
                        <div class="detail-item">
                            <i class="fas fa-clock"></i>
                            <span><?php echo date('H:i', strtotime($ride['time'])); ?></span>
                        </div>
                        <div class="detail-item">
                            <i class="fas fa-users"></i>
                            <span><?php echo $ride['participants_count']; ?> مشارك</span>
                        </div>
                    </div>
                    
                    <div class="ride-description">
                        <p><?php echo htmlspecialchars($ride['description']); ?></p>
                    </div>
                    
                    <div class="ride-actions">
                        <?php if ($ride['user_joined']): ?>
                            <button class="btn btn-success" disabled>
                                <i class="fas fa-check"></i>
                                منضم
                            </button>
                        <?php else: ?>
                            <button class="btn btn-primary join-ride-btn" data-ride-id="<?php echo $ride['id']; ?>">
                                <i class="fas fa-plus"></i>
                                انضم للخرجة
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
            </div>
            </section>
        </div>
    </main>
</div>

<?php require_once 'includes/dashboard_footer.php'; ?>
