<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>رايد المغرب - مغامرات الدراجات النارية</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <nav class="navbar">
            <div class="nav-container">
                <div class="nav-logo">
                    <i class="fas fa-motorcycle"></i>
                    <span>رايد المغرب</span>
                </div>
                <ul class="nav-menu">
                    <li class="nav-item">
                        <a href="#home" class="nav-link active">الرئيسية</a>
                    </li>
                    <li class="nav-item">
                        <a href="#rides" class="nav-link">الخرجات</a>
                    </li>
                    <li class="nav-item">
                        <a href="#about" class="nav-link">حولنا</a>
                    </li>
                    <li class="nav-item">
                        <a href="#contact" class="nav-link">اتصل بنا</a>
                    </li>
                </ul>
                <div class="nav-buttons">
                    <a href="login.php" class="btn btn-outline">تسجيل الدخول</a>
                    <a href="register.php" class="btn btn-primary">إنشاء حساب</a>
                </div>
                <div class="hamburger">
                    <span class="bar"></span>
                    <span class="bar"></span>
                    <span class="bar"></span>
                </div>
            </div>
        </nav>
    </header>

    <!-- Hero Section -->
    <section id="home" class="hero">
        <div class="hero-overlay"></div>
        <div class="hero-content">
            <h1 class="hero-title">انضم إلينا في مغامرات لا تُنسى</h1>
            <p class="hero-subtitle">اكتشف جمال المغرب على ظهر دراجتك النارية مع مجموعة من عشاق المغامرة</p>
            <div class="hero-buttons">
                <a href="register.php" class="btn btn-primary btn-large">ابدأ مغامرتك الآن</a>
                <a href="#rides" class="btn btn-outline btn-large">تصفح الخرجات</a>
            </div>
        </div>
        <div class="hero-stats">
            <div class="stat">
                <h3>500+</h3>
                <p>عضو نشط</p>
            </div>
            <div class="stat">
                <h3>50+</h3>
                <p>خرجة شهرياً</p>
            </div>
            <div class="stat">
                <h3>10+</h3>
                <p>مدن مغربية</p>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="rides" class="features">
        <div class="container">
            <h2 class="section-title">لماذا رايد المغرب؟</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-route"></i>
                    </div>
                    <h3>مسارات متنوعة</h3>
                    <p>من الجبال الشاهقة إلى الصحراء الذهبية، اكتشف أجمل المناظر الطبيعية في المغرب</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>مجتمع متماسك</h3>
                    <p>انضم إلى مجتمع من عشاق الدراجات النارية واصنع صداقات جديدة</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>سلامة مضمونة</h3>
                    <p>نحن نولي أقصى اهتمام للسلامة مع قادة خبراء ومعدات احترافية</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <h3>خرجات منتظمة</h3>
                    <p>خرجات أسبوعية ونهاية الأسبوع لتناسب جميع الأوقات</p>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="about">
        <div class="container">
            <div class="about-content">
                <div class="about-text">
                    <h2>من نحن؟</h2>
                    <p>رايد المغرب هو أكبر مجتمع لعشاق الدراجات النارية في المغرب. نحن نؤمن بأن المغامرة الحقيقية تبدأ عندما تنطلق على طريق مفتوح مع أصدقاء يشاركونك نفس الشغف.</p>
                    <p>منذ تأسيسنا، نظمنا المئات من الخرجات الجماعية عبر أجمل المناطق المغربية، من الأطلس الكبير إلى ساحل المحيط الأطلسي.</p>
                    <div class="about-features">
                        <div class="about-feature">
                            <i class="fas fa-check"></i>
                            <span>خبرة أكثر من 5 سنوات</span>
                        </div>
                        <div class="about-feature">
                            <i class="fas fa-check"></i>
                            <span>فريق من القادة المحترفين</span>
                        </div>
                        <div class="about-feature">
                            <i class="fas fa-check"></i>
                            <span>تغطية شاملة لجميع مناطق المغرب</span>
                        </div>
                    </div>
                </div>
                <div class="about-image">
                    <img src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=500&q=80" alt="فريق رايد المغرب">
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="contact">
        <div class="container">
            <h2 class="section-title">تواصل معنا</h2>
            <div class="contact-content">
                <div class="contact-info">
                    <div class="contact-item">
                        <i class="fas fa-phone"></i>
                        <div>
                            <h4>الهاتف</h4>
                            <p>+212 6XX XXX XXX</p>
                        </div>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-envelope"></i>
                        <div>
                            <h4>البريد الإلكتروني</h4>
                            <p>info@ridemorocco.ma</p>
                        </div>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-map-marker-alt"></i>
                        <div>
                            <h4>العنوان</h4>
                            <p>الدار البيضاء، المغرب</p>
                        </div>
                    </div>
                </div>
                <div class="contact-form">
                    <form id="contactForm" action="contact.php" method="POST">
                        <div class="form-group">
                            <input type="text" name="name" placeholder="الاسم الكامل" required>
                        </div>
                        <div class="form-group">
                            <input type="email" name="email" placeholder="البريد الإلكتروني" required>
                        </div>
                        <div class="form-group">
                            <textarea name="message" placeholder="رسالتك" rows="5" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">إرسال الرسالة</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <div class="footer-logo">
                        <i class="fas fa-motorcycle"></i>
                        <span>رايد المغرب</span>
                    </div>
                    <p>انضم إلى أكبر مجتمع لعشاق الدراجات النارية في المغرب</p>
                    <div class="social-links">
                        <a href="#"><i class="fab fa-facebook"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-youtube"></i></a>
                        <a href="#"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>
                <div class="footer-section">
                    <h4>روابط سريعة</h4>
                    <ul>
                        <li><a href="#home">الرئيسية</a></li>
                        <li><a href="#rides">الخرجات</a></li>
                        <li><a href="#about">حولنا</a></li>
                        <li><a href="#contact">اتصل بنا</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>المدن</h4>
                    <ul>
                        <li><a href="#">الدار البيضاء</a></li>
                        <li><a href="#">الرباط</a></li>
                        <li><a href="#">مراكش</a></li>
                        <li><a href="#">فاس</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 رايد المغرب. جميع الحقوق محفوظة.</p>
            </div>
        </div>
    </footer>

    <script src="public/js/main.js"></script>
</body>
</html>
