<?php
// Get current user if not already loaded
if (!isset($user)) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
}
?>
<!-- Top Bar -->
<header class="top-bar">
    <div class="top-bar-left">
        <button class="mobile-menu-btn" id="mobileMenuBtn">
            <i class="fas fa-bars"></i>
        </button>
        <h1 id="pageTitle"><?php echo $page_title ?? 'لوحة التحكم'; ?></h1>
    </div>
    <div class="top-bar-right">
        <div class="user-info">
            <div class="user-avatar">
                <i class="fas fa-user"></i>
            </div>
            <span class="user-name"><?php echo htmlspecialchars($user['name']); ?></span>
        </div>
    </div>
</header>
