<?php
$page_title = 'خرجاتي';
require_once 'includes/dashboard_header.php';

// Get user's rides
$stmt = $pdo->prepare("
    SELECT r.*, rp.joined_at
    FROM rides r 
    INNER JOIN ride_participants rp ON r.id = rp.ride_id 
    WHERE rp.user_id = ?
    ORDER BY r.date DESC
");
$stmt->execute([$_SESSION['user_id']]);
$user_rides = $stmt->fetchAll();
?>

<div class="dashboard-container">
    <?php include 'includes/dashboard_sidebar.php'; ?>

    <main class="main-content">
        <?php include 'includes/dashboard_topbar.php'; ?>
        
        <div class="content-wrapper">
            <section class="content-section">
    <div class="section-header">
        <h2>خرجاتي</h2>
        <p>الخرجات التي انضممت إليها</p>
    </div>

    <div class="rides-grid">
        <?php if (empty($user_rides)): ?>
            <div class="empty-state">
                <i class="fas fa-route"></i>
                <h3>لم تنضم لأي خرجة بعد</h3>
                <p>انضم للخرجات القادمة واستمتع بالمغامرة</p>
                <a href="upcoming-rides.php" class="btn btn-primary">
                    <i class="fas fa-calendar-plus"></i>
                    تصفح الخرجات القادمة
                </a>
            </div>
        <?php else: ?>
            <?php foreach ($user_rides as $ride): ?>
                <div class="ride-card">
                    <div class="ride-header">
                        <h3><?php echo htmlspecialchars($ride['title']); ?></h3>
                        <div class="ride-status">
                            <?php if (strtotime($ride['date']) > time()): ?>
                                <span class="status-badge status-upcoming">قادمة</span>
                            <?php else: ?>
                                <span class="status-badge status-completed">مكتملة</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="ride-details">
                        <div class="detail-item">
                            <i class="fas fa-calendar"></i>
                            <span><?php echo date('d/m/Y', strtotime($ride['date'])); ?></span>
                        </div>
                        <div class="detail-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <span><?php echo htmlspecialchars($ride['location']); ?></span>
                        </div>
                        <div class="detail-item">
                            <i class="fas fa-clock"></i>
                            <span><?php echo date('H:i', strtotime($ride['time'])); ?></span>
                        </div>
                        <div class="detail-item">
                            <i class="fas fa-user-check"></i>
                            <span>انضممت في <?php echo date('d/m/Y', strtotime($ride['joined_at'])); ?></span>
                        </div>
                    </div>
                    
                    <div class="ride-description">
                        <p><?php echo htmlspecialchars($ride['description']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
            </div>
            </section>
        </div>
    </main>
</div>

<?php require_once 'includes/dashboard_footer.php'; ?>
