# رايد المغرب - موقع تنظيم خرجات الدراجات النارية

موقع ويب حديث وعصري لتنظيم خرجات جماعية لعشاق الدراجات النارية في المغرب.

## المميزات

### 🏠 الصفحة الرئيسية
- تصميم حماسي مع خلفية صور الدراجات النارية
- هيدر متناسق مع شعار الموقع وقائمة التنقل
- أزرار بارزة لتسجيل الدخول وإنشاء حساب
- أقسام: الرئيسية - الخرجات - حولنا - اتصل بنا

### 🔐 نظام المستخدمين
- تسجيل حساب جديد بالاسم ورقم الهاتف والمدينة
- تسجيل الدخول برقم الهاتف وكلمة المرور
- حماية كلمات المرور بالتشفير
- جلسات آمنة للمستخدمين

### 📊 لوحة التحكم
- واجهة عصرية مع شريط جانبي
- إحصائيات شخصية للمستخدم
- عرض الخرجات القادمة
- إدارة الخرجات المنضم إليها
- تحديث الملف الشخصي

### 🏍️ إدارة الخرجات
- عرض الخرجات القادمة مع التفاصيل
- الانضمام للخرجات المتاحة
- تصفية الخرجات حسب المدينة
- عرض عدد المشاركين لكل خرجة

## المتطلبات التقنية

- خادم ويب يدعم PHP 7.4+
- قاعدة بيانات MySQL 5.7+
- مساحة تخزين للملفات

## التثبيت على الاستضافة

### 1. رفع الملفات
قم برفع جميع الملفات إلى مجلد الموقع على الاستضافة

### 2. إعداد قاعدة البيانات
1. أنشئ قاعدة بيانات جديدة من لوحة تحكم الاستضافة
2. استورد ملف `database.sql` إلى قاعدة البيانات
3. احفظ بيانات الاتصال (اسم القاعدة، اسم المستخدم، كلمة المرور)

### 3. تحديث إعدادات الاتصال
عدّل ملف `config.php` وحدّث البيانات التالية:
```php
define('DB_HOST', 'localhost'); // عادة localhost
define('DB_NAME', 'اسم_قاعدة_البيانات');
define('DB_USER', 'اسم_المستخدم');
define('DB_PASS', 'كلمة_المرور');
define('SITE_URL', 'https://موقعك.com');
```

### 4. ضبط الصلاحيات
تأكد من أن مجلد الموقع له صلاحيات القراءة والكتابة

## المدن المدعومة

- الدار البيضاء
- الرباط  
- تمارة
- المحمدية
- سطات
- سلا
- القنيطرة
- الجديدة
- برشيد

## الملفات الرئيسية

- `index.php` - الصفحة الرئيسية
- `register.php` - صفحة التسجيل
- `login.php` - صفحة تسجيل الدخول
- `dashboard.php` - لوحة تحكم المستخدم
- `config.php` - إعدادات الموقع وقاعدة البيانات
- `database.sql` - هيكل قاعدة البيانات
- `public/` - مجلد الملفات العامة (CSS, JS, الصور)

## الأمان

- تشفير كلمات المرور باستخدام `password_hash()`
- حماية من SQL Injection باستخدام Prepared Statements
- تنظيف البيانات المدخلة من المستخدمين
- جلسات آمنة مع إعدادات محسنة

## الدعم

للحصول على الدعم أو الإبلاغ عن مشاكل، يرجى التواصل عبر صفحة "اتصل بنا" في الموقع.

## الترخيص

هذا المشروع مفتوح المصدر ومتاح للاستخدام والتطوير.

---

**رايد المغرب** - انضم إلى أكبر مجتمع لعشاق الدراجات النارية في المغرب! 🏍️
