<?php
require_once 'config.php';
require_once 'functions.php';

// If user is already logged in, redirect to dashboard
if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitize($_POST['name']);
    $phone = sanitize($_POST['phone']);
    $password = $_POST['password'];
    $city = sanitize($_POST['city']);
    
    // Basic validation
    if (empty($name) || empty($phone) || empty($password) || empty($city)) {
        $error = 'يرجى ملء جميع الحقول';
    } elseif (!validatePhone($phone)) {
        $error = 'رقم الهاتف غير صحيح';
    } elseif (strlen($password) < 6) {
        $error = 'كلمة المرور يجب أن تكون 6 أحرف على الأقل';
    } else {
        // Check if phone exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE phone = ?");
        $stmt->execute([$phone]);
        
        if ($stmt->fetch()) {
            $error = 'رقم الهاتف مسجل مسبقاً';
        } else {
            // Insert new user
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (name, phone, password, city) VALUES (?, ?, ?, ?)");
            
            if ($stmt->execute([$name, $phone, $hashedPassword, $city])) {
                redirect('login.php?message=تم التسجيل بنجاح');
            } else {
                $error = 'خطأ في التسجيل';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إنشاء حساب - رايد المغرب</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="public/css/auth.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="auth-container">
        <div class="auth-background"></div>
        <div class="auth-content">
            <div class="auth-card">
                <div class="auth-header">
                    <div class="auth-logo">
                        <i class="fas fa-motorcycle"></i>
                        <span>رايد المغرب</span>
                    </div>
                    <h2>إنشاء حساب جديد</h2>
                    <p>انضم إلى مجتمع عشاق الدراجات النارية</p>
                </div>

                <?php if ($error): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>


                <form method="POST" class="auth-form">
                    <div class="form-group">
                        <label for="name">الاسم الكامل</label>
                        <div class="input-group">
                            <i class="fas fa-user"></i>
                            <input type="text" id="name" name="name" required placeholder="أدخل اسمك الكامل" value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="phone">رقم الهاتف</label>
                        <div class="input-group">
                            <i class="fas fa-phone"></i>
                            <input type="tel" id="phone" name="phone" required placeholder="06XXXXXXXX" value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="city">المدينة</label>
                        <div class="input-group">
                            <i class="fas fa-map-marker-alt"></i>
                            <select id="city" name="city" required>
                                <option value="">اختر مدينتك</option>
                                <option value="الدار البيضاء" <?php echo (isset($_POST['city']) && $_POST['city'] === 'الدار البيضاء') ? 'selected' : ''; ?>>الدار البيضاء</option>
                                <option value="الرباط" <?php echo (isset($_POST['city']) && $_POST['city'] === 'الرباط') ? 'selected' : ''; ?>>الرباط</option>
                                <option value="تمارة" <?php echo (isset($_POST['city']) && $_POST['city'] === 'تمارة') ? 'selected' : ''; ?>>تمارة</option>
                                <option value="المحمدية" <?php echo (isset($_POST['city']) && $_POST['city'] === 'المحمدية') ? 'selected' : ''; ?>>المحمدية</option>
                                <option value="سطات" <?php echo (isset($_POST['city']) && $_POST['city'] === 'سطات') ? 'selected' : ''; ?>>سطات</option>
                                <option value="سلا" <?php echo (isset($_POST['city']) && $_POST['city'] === 'سلا') ? 'selected' : ''; ?>>سلا</option>
                                <option value="القنيطرة" <?php echo (isset($_POST['city']) && $_POST['city'] === 'القنيطرة') ? 'selected' : ''; ?>>القنيطرة</option>
                                <option value="الجديدة" <?php echo (isset($_POST['city']) && $_POST['city'] === 'الجديدة') ? 'selected' : ''; ?>>الجديدة</option>
                                <option value="برشيد" <?php echo (isset($_POST['city']) && $_POST['city'] === 'برشيد') ? 'selected' : ''; ?>>برشيد</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password">كلمة المرور</label>
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input type="password" id="password" name="password" required placeholder="أدخل كلمة مرور قوية">
                            <button type="button" class="password-toggle" onclick="togglePassword('password')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="confirmPassword">تأكيد كلمة المرور</label>
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input type="password" id="confirmPassword" name="confirmPassword" required placeholder="أعد إدخال كلمة المرور">
                            <button type="button" class="password-toggle" onclick="togglePassword('confirmPassword')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="form-group checkbox-group">
                        <label class="checkbox-label">
                            <input type="checkbox" id="terms" required>
                            <span class="checkmark"></span>
                            أوافق على <a href="#" class="link">الشروط والأحكام</a> و <a href="#" class="link">سياسة الخصوصية</a>
                        </label>
                    </div>

                    <button type="submit" class="btn btn-primary btn-full">إنشاء الحساب</button>
                </form>

                <div class="auth-footer">
                    <p>لديك حساب بالفعل؟ <a href="login.php" class="link">تسجيل الدخول</a></p>
                    <a href="index.php" class="back-home">
                        <i class="fas fa-arrow-right"></i>
                        العودة للرئيسية
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script>
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const toggle = input.parentElement.querySelector('.password-toggle i');
            
            if (input.type === 'password') {
                input.type = 'text';
                toggle.classList.remove('fa-eye');
                toggle.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                toggle.classList.remove('fa-eye-slash');
                toggle.classList.add('fa-eye');
            }
        }
    </script>
</body>
</html>
