<?php
require_once 'config.php';

// Require login
requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rideId = (int)$_POST['ride_id'];
    $userId = $_SESSION['user_id'];
    
    // Check if ride exists and is in the future
    $stmt = $pdo->prepare("SELECT * FROM rides WHERE id = ? AND date >= CURDATE()");
    $stmt->execute([$rideId]);
    $ride = $stmt->fetch();
    
    if (!$ride) {
        jsonResponse(['success' => false, 'message' => 'الخرجة غير موجودة أو انتهت']);
    }
    
    // Check if user already joined
    $stmt = $pdo->prepare("SELECT id FROM ride_participants WHERE user_id = ? AND ride_id = ?");
    $stmt->execute([$userId, $rideId]);
    
    if ($stmt->fetch()) {
        jsonResponse(['success' => false, 'message' => 'أنت منضم بالفعل لهذه الخرجة']);
    }
    
    // Check if ride is full
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM ride_participants WHERE ride_id = ?");
    $stmt->execute([$rideId]);
    $participantsCount = $stmt->fetch()['count'];
    
    if ($participantsCount >= $ride['max_participants']) {
        jsonResponse(['success' => false, 'message' => 'الخرجة مكتملة العدد']);
    }
    
    // Join the ride
    $stmt = $pdo->prepare("INSERT INTO ride_participants (user_id, ride_id) VALUES (?, ?)");
    
    if ($stmt->execute([$userId, $rideId])) {
        jsonResponse(['success' => true, 'message' => 'تم الانضمام للخرجة بنجاح!']);
    } else {
        jsonResponse(['success' => false, 'message' => 'حدث خطأ أثناء الانضمام']);
    }
}

// If not POST request, redirect to dashboard
redirect('dashboard.php');
?>
