<?php
// Shared functions for RideMorocco website

// Authentication functions
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function redirect($url) {
    header('Location: ' . $url);
    exit;
}

// Data validation functions
function sanitize($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function validatePhone($phone) {
    $phone = preg_replace('/\s+/', '', $phone);
    return preg_match('/^(06|07)\d{8}$/', $phone);
}

function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

// JSON response function
function jsonResponse($data) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

// Get current user data
function getCurrentUser($pdo) {
    if (!isLoggedIn()) {
        return null;
    }
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    return $stmt->fetch();
}

// Format date for display
function formatDate($date) {
    return date('d/m/Y', strtotime($date));
}

// Get Moroccan cities
function getMoroccanCities() {
    return [
        'الدار البيضاء',
        'الرباط',
        'تمارة',
        'المحمدية',
        'سطات',
        'سلا',
        'القنيطرة',
        'الجديدة',
        'برشيد',
        'مراكش',
        'فاس',
        'طنجة',
        'أكادير',
        'وجدة'
    ];
}

// Check if current page matches
function isCurrentPage($page) {
    return basename($_SERVER['PHP_SELF'], '.php') === $page;
}
?>
