<?php
require_once 'config.php';
require_once 'functions.php';

// Require login
requireLogin();

// Get current user
$user = getCurrentUser($pdo);

// Get user's rides count
$stmt = $pdo->prepare("SELECT COUNT(*) as count FROM ride_participants WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$userRidesCount = $stmt->fetch()['count'];

// Get upcoming rides count
$stmt = $pdo->prepare("SELECT COUNT(*) as count FROM rides WHERE date >= CURDATE()");
$stmt->execute();
$upcomingRidesCount = $stmt->fetch()['count'];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - رايد المغرب</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="public/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="logo">
                    <i class="fas fa-motorcycle"></i>
                    <span>رايد المغرب</span>
                </div>
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>

            <nav class="sidebar-nav">
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="dashboard.php" class="nav-link active">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>الرئيسية</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="upcoming-rides.php" class="nav-link">
                            <i class="fas fa-calendar-plus"></i>
                            <span>الخرجات القادمة</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="my-rides.php" class="nav-link">
                            <i class="fas fa-route"></i>
                            <span>خرجاتي</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="profile.php" class="nav-link">
                            <i class="fas fa-user"></i>
                            <span>ملفي الشخصي</span>
                        </a>
                    </li>
                </ul>
            </nav>

            <div class="sidebar-footer">
                <a href="logout.php" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>تسجيل الخروج</span>
                </a>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <header class="top-bar">
                <div class="top-bar-left">
                    <button class="mobile-menu-btn" id="mobileMenuBtn">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 id="pageTitle">لوحة التحكم</h1>
                </div>
                <div class="top-bar-right">
                    <div class="user-info">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <span class="user-name"><?php echo htmlspecialchars($user['name']); ?></span>
                    </div>
                </div>
            </header>

            <!-- Content Sections -->
            <div class="content-wrapper">
                <!-- Dashboard Section -->
                <section class="dashboard-section">
                    <div class="stats-grid">
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-route"></i>
                            </div>
                            <div class="stat-info">
                                <h3><?php echo $userRidesCount; ?></h3>
                                <p>إجمالي الخرجات</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                            <div class="stat-info">
                                <h3><?php echo $upcomingRidesCount; ?></h3>
                                <p>خرجات قادمة</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="stat-info">
                                <h3>500+</h3>
                                <p>أعضاء المجتمع</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <div class="stat-info">
                                <h3>4.8</h3>
                                <p>تقييم المجتمع</p>
                            </div>
                        </div>
                    </div>

                    <div class="dashboard-grid">
                        <div class="dashboard-card">
                            <div class="card-header">
                                <h3>الخرجات القادمة</h3>
                                <a href="#upcoming-rides" class="view-all">عرض الكل</a>
                            </div>
                            <div class="card-content">
                                <div id="recentRides" class="rides-list">
                                    <?php
                                    $stmt = $pdo->prepare("SELECT * FROM rides WHERE date >= CURDATE() ORDER BY date ASC LIMIT 3");
                                    $stmt->execute();
                                    $recentRides = $stmt->fetchAll();
                                    
                                    if ($recentRides): ?>
                                        <?php foreach ($recentRides as $ride): ?>
                                            <div class="ride-item">
                                                <div class="ride-info">
                                                    <h4><?php echo htmlspecialchars($ride['title']); ?></h4>
                                                    <p><i class="fas fa-calendar"></i> <?php echo date('d/m/Y', strtotime($ride['date'])); ?></p>
                                                    <p><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($ride['location']); ?></p>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <p>لا توجد خرجات قادمة حالياً</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="dashboard-card">
                            <div class="card-header">
                                <h3>نشاطي الأخير</h3>
                            </div>
                            <div class="card-content">
                                <div class="activity-list">
                                    <div class="activity-item">
                                        <div class="activity-icon">
                                            <i class="fas fa-user-plus"></i>
                                        </div>
                                        <div class="activity-info">
                                            <p>انضممت إلى المجتمع</p>
                                            <span class="activity-time"><?php echo date('d/m/Y', strtotime($user['created_at'])); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </main>
    </div>

    <script>
        // Simple mobile menu toggle
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('active');
                });
                
                // Close menu when clicking outside
                document.addEventListener('click', function(e) {
                    if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                        sidebar.classList.remove('active');
                    }
                });
            }
        });
    </script>
</body>
</html>
