<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\TournamentClanController;
use App\Http\Controllers\Admin\TournamentController;
use App\Models\Tournament;
use App\Models\TournamentClan;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    $tournament = Tournament::active()->first();

    $clans = collect();
    if ($tournament) {
        $clans = TournamentClan::query()
            ->where('tournament_id', $tournament->id)
            ->with('clan')
            ->orderBy('id')
            ->get()
            ->map(fn ($tc) => $tc->clan)
            ->filter();
    }

    return view('dashboard', [
        'tournament' => $tournament,
        'clans' => $clans,
    ]);
})->middleware(['auth'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::prefix('tournament')->group(function () {
        Route::post('/clans', [TournamentClanController::class, 'store'])
            ->middleware('tournament.active')
            ->name('tournament.clans.create');

        Route::post('/clans/join', [TournamentClanController::class, 'join'])
            ->middleware('tournament.active')
            ->name('tournament.clans.join');
    });
});

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::resource('tournaments', TournamentController::class);

    Route::post('tournaments/{tournament}/activate', [TournamentController::class, 'activate'])->name('tournaments.activate');
    Route::post('tournaments/{tournament}/lock', [TournamentController::class, 'lock'])->name('tournaments.lock');
    Route::post('tournaments/{tournament}/unlock', [TournamentController::class, 'unlock'])->name('tournaments.unlock');
});

require __DIR__.'/auth.php';
