<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            @if ($errors->any())
                <div class="bg-red-50 border border-red-200 text-red-800 p-4 rounded">
                    <ul class="list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 space-y-3">
                    <div class="font-semibold">الحالة</div>

                    <div>
                        المستخدم: <b>{{ Auth::user()->name }}</b>
                        | الدور: <b>{{ Auth::user()->role }}</b>
                        | التفعيل: <b>{{ Auth::user()->is_active ? 'مفعل' : 'غير مفعل' }}</b>
                    </div>

                    @if ($tournament)
                        <div>
                            البطولة النشطة: <b>{{ $tournament->name }}</b>
                            | مقفولة: <b>{{ $tournament->is_locked ? 'نعم' : 'لا' }}</b>
                        </div>
                    @else
                        <div class="text-gray-700">لا توجد بطولة نشطة حالياً.</div>
                    @endif
                </div>
            </div>

            @if ($tournament)
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6 text-gray-900 space-y-4">
                            <div class="font-semibold">إنشاء / انضمام لكلان</div>

                            @if (!Auth::user()->is_active)
                                <div class="text-gray-700">
                                    حسابك غير مُفعّل بعد. يمكنك تصفح الموقع، لكن لا يمكنك إنشاء أو الانضمام إلى كلان داخل قسم البطولات حتى يتم تفعيل حسابك من الإدارة.
                                </div>
                            @else
                                @if (Auth::user()->role === 'leader')
                                    <form method="POST" action="{{ route('tournament.clans.create') }}" class="space-y-3">
                                        @csrf
                                        <div>
                                            <label class="block mb-1">اسم الكلان</label>
                                            <input name="name" class="w-full border rounded p-2" required value="{{ old('name') }}">
                                        </div>
                                        <button class="px-4 py-2 bg-black text-white rounded" @if($tournament->is_locked) disabled @endif>
                                            إنشاء كلان
                                        </button>
                                        @if($tournament->is_locked)
                                            <div class="text-sm text-gray-600">البطولة مقفولة حالياً، لا يمكن إنشاء كلانات.</div>
                                        @endif
                                    </form>
                                @elseif (Auth::user()->role === 'player')
                                    <form method="POST" action="{{ route('tournament.clans.join') }}" class="space-y-3">
                                        @csrf
                                        <div>
                                            <label class="block mb-1">اختر كلان</label>
                                            <select name="clan_id" class="w-full border rounded p-2" required>
                                                <option value="">-- اختر --</option>
                                                @foreach($clans as $clan)
                                                    <option value="{{ $clan->id }}">{{ $clan->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button class="px-4 py-2 bg-black text-white rounded" @if($tournament->is_locked) disabled @endif>
                                            انضمام
                                        </button>
                                        @if($tournament->is_locked)
                                            <div class="text-sm text-gray-600">البطولة مقفولة حالياً، لا يمكن الانضمام.</div>
                                        @endif
                                    </form>
                                @else
                                    <div class="text-gray-700">هذا الحساب ليس Player أو Leader.</div>
                                @endif
                            @endif
                        </div>
                    </div>

                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6 text-gray-900 space-y-3">
                            <div class="font-semibold">الكلانات المسجلة في البطولة</div>

                            @if($clans->count() === 0)
                                <div class="text-gray-700">لا توجد كلانات مسجلة بعد.</div>
                            @else
                                <ul class="space-y-2">
                                    @foreach($clans as $clan)
                                        <li class="border rounded p-3 flex justify-between">
                                            <span>{{ $clan->name }}</span>
                                            <span class="text-sm text-gray-600">ID: {{ $clan->id }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
