<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ $tournament->name }}
            </h2>
            <div class="flex gap-2">
                <a class="px-3 py-2 border rounded" href="{{ route('admin.tournaments.edit', $tournament) }}">تعديل</a>
                <a class="px-3 py-2 border rounded" href="{{ route('admin.tournaments.index') }}">رجوع</a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-4">

            <div class="bg-white shadow-sm sm:rounded-lg">
                <div class="p-6 space-y-2">
                    <div>نشطة: <b>{{ $tournament->is_active ? 'نعم' : 'لا' }}</b></div>
                    <div>مقفولة: <b>{{ $tournament->is_locked ? 'نعم' : 'لا' }}</b></div>

                    <div class="flex gap-2 pt-2">
                        <form method="POST" action="{{ route('admin.tournaments.activate', $tournament) }}">
                            @csrf
                            <button class="px-3 py-2 bg-black text-white rounded">تفعيل البطولة</button>
                        </form>

                        @if(!$tournament->is_locked)
                            <form method="POST" action="{{ route('admin.tournaments.lock', $tournament) }}">
                                @csrf
                                <button class="px-3 py-2 bg-yellow-600 text-white rounded">قفل</button>
                            </form>
                        @else
                            <form method="POST" action="{{ route('admin.tournaments.unlock', $tournament) }}">
                                @csrf
                                <button class="px-3 py-2 bg-green-700 text-white rounded">فك القفل</button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>

            <div class="bg-white shadow-sm sm:rounded-lg overflow-hidden">
                <div class="p-6">
                    <h3 class="font-semibold mb-4">الكلانات المشاركة وأعضاء كل كلان</h3>

                    @forelse($tournamentClans as $tc)
                        <div class="border rounded p-4 mb-4">
                            <div class="flex justify-between">
                                <div class="font-semibold">{{ $tc->clan->name }}</div>
                                <div class="text-sm text-gray-600">النقاط: {{ $tc->total_points }} | الفوز: {{ $tc->total_wins }}</div>
                            </div>

                            <div class="text-sm text-gray-600 mt-1">
                                القائد: {{ optional($tc->clan->leader)->name }}
                            </div>

                            <div class="mt-3">
                                <table class="w-full text-sm">
                                    <thead>
                                        <tr class="border-b">
                                            <th class="py-2 text-right">اللاعب</th>
                                            <th class="text-right">Email</th>
                                            <th class="text-right">Slot</th>
                                            <th class="text-right">Active</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($tc->clan->members as $m)
                                            <tr class="border-b">
                                                <td class="py-2">{{ optional($m->user)->name }}</td>
                                                <td>{{ optional($m->user)->email }}</td>
                                                <td>{{ $m->slot }}</td>
                                                <td>{{ optional($m->user)->is_active ? 'نعم' : 'لا' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @empty
                        <div class="text-gray-600">لا توجد كلانات مسجلة في هذه البطولة بعد.</div>
                    @endforelse
                </div>
            </div>

        </div>
    </div>
</x-app-layout>
