<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">إدارة البطولات</h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-4">
            <div class="flex justify-end">
                <a href="{{ route('admin.tournaments.create') }}" class="px-4 py-2 bg-black text-white rounded">إنشاء بطولة</a>
            </div>

            <div class="bg-white shadow-sm sm:rounded-lg overflow-hidden">
                <div class="p-6">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="text-right border-b">
                                <th class="py-2">#</th>
                                <th>الاسم</th>
                                <th>نشطة</th>
                                <th>مقفولة</th>
                                <th>تاريخ البداية</th>
                                <th class="text-left">إجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($tournaments as $t)
                                <tr class="border-b">
                                    <td class="py-2">{{ $t->id }}</td>
                                    <td>{{ $t->name }}</td>
                                    <td>{{ $t->is_active ? 'نعم' : 'لا' }}</td>
                                    <td>{{ $t->is_locked ? 'نعم' : 'لا' }}</td>
                                    <td>{{ optional($t->starts_at)->format('Y-m-d H:i') }}</td>
                                    <td class="text-left space-x-2 space-x-reverse">
                                        <a class="underline" href="{{ route('admin.tournaments.show', $t) }}">عرض</a>
                                        <a class="underline" href="{{ route('admin.tournaments.edit', $t) }}">تعديل</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <div class="mt-4">
                        {{ $tournaments->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
