<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">تعديل بطولة</h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow-sm sm:rounded-lg">
                <div class="p-6 space-y-4">
                    <form method="POST" action="{{ route('admin.tournaments.update', $tournament) }}" class="space-y-4">
                        @csrf
                        @method('PUT')

                        <div>
                            <label class="block mb-1">اسم البطولة</label>
                            <input name="name" class="w-full border rounded p-2" required value="{{ old('name', $tournament->name) }}">
                        </div>

                        <div>
                            <label class="block mb-1">الوصف</label>
                            <textarea name="description" class="w-full border rounded p-2">{{ old('description', $tournament->description) }}</textarea>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block mb-1">الحد الأقصى للكلانات</label>
                                <input type="number" name="max_clans" class="w-full border rounded p-2" value="{{ old('max_clans', $tournament->max_clans) }}">
                            </div>
                            <div>
                                <label class="block mb-1">قيمة الجوائز</label>
                                <input type="number" name="prize_pool" class="w-full border rounded p-2" value="{{ old('prize_pool', $tournament->prize_pool) }}">
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block mb-1">تاريخ البداية</label>
                                <input type="datetime-local" name="starts_at" class="w-full border rounded p-2" value="{{ old('starts_at') }}">
                            </div>
                            <div>
                                <label class="block mb-1">تاريخ النهاية</label>
                                <input type="datetime-local" name="ends_at" class="w-full border rounded p-2" value="{{ old('ends_at') }}">
                            </div>
                        </div>

                        <div class="flex justify-end gap-2">
                            <a href="{{ route('admin.tournaments.show', $tournament) }}" class="px-4 py-2 border rounded">رجوع</a>
                            <button class="px-4 py-2 bg-black text-white rounded">حفظ</button>
                        </div>
                    </form>

                    <form method="POST" action="{{ route('admin.tournaments.destroy', $tournament) }}">
                        @csrf
                        @method('DELETE')
                        <button class="px-4 py-2 bg-red-600 text-white rounded">حذف البطولة</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
