<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">إنشاء بطولة</h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow-sm sm:rounded-lg">
                <div class="p-6 space-y-4">
                    <form method="POST" action="{{ route('admin.tournaments.store') }}" class="space-y-4">
                        @csrf

                        <div>
                            <label class="block mb-1">اسم البطولة</label>
                            <input name="name" class="w-full border rounded p-2" required value="{{ old('name') }}">
                            @error('name')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                        </div>

                        <div>
                            <label class="block mb-1">الوصف</label>
                            <textarea name="description" class="w-full border rounded p-2">{{ old('description') }}</textarea>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block mb-1">الحد الأقصى للكلانات</label>
                                <input type="number" name="max_clans" class="w-full border rounded p-2" value="{{ old('max_clans') }}">
                            </div>
                            <div>
                                <label class="block mb-1">قيمة الجوائز</label>
                                <input type="number" name="prize_pool" class="w-full border rounded p-2" value="{{ old('prize_pool', 0) }}">
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block mb-1">تاريخ البداية</label>
                                <input type="datetime-local" name="starts_at" class="w-full border rounded p-2" value="{{ old('starts_at') }}">
                            </div>
                            <div>
                                <label class="block mb-1">تاريخ النهاية</label>
                                <input type="datetime-local" name="ends_at" class="w-full border rounded p-2" value="{{ old('ends_at') }}">
                            </div>
                        </div>

                        <div class="flex items-center gap-2">
                            <input id="is_active" type="checkbox" name="is_active" value="1">
                            <label for="is_active">تفعيل البطولة مباشرة</label>
                        </div>

                        <div class="flex justify-end gap-2">
                            <a href="{{ route('admin.tournaments.index') }}" class="px-4 py-2 border rounded">رجوع</a>
                            <button class="px-4 py-2 bg-black text-white rounded">حفظ</button>
                        </div>
                    </form>

                    @if($errors->any())
                        <div class="text-red-600 text-sm">تحقق من الحقول.</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
