<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tournament_clans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tournament_id')->constrained('tournaments')->cascadeOnDelete();
            $table->foreignId('clan_id')->constrained('clans')->cascadeOnDelete();

            $table->unsignedInteger('current_rank')->nullable();
            $table->boolean('is_eliminated')->default(false);
            $table->timestamp('eliminated_at')->nullable();
            $table->unsignedInteger('total_points')->default(0);
            $table->unsignedInteger('total_wins')->default(0);
            $table->unsignedInteger('prize')->default(0);
            $table->timestamps();

            $table->unique(['tournament_id', 'clan_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tournament_clans');
    }
};
