<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clans', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('logo')->nullable();

            $table->foreignId('leader_id')->constrained('users')->cascadeOnDelete();
            $table->boolean('is_ready')->default(false);
            $table->enum('payment_status', ['pending', 'paid'])->default('pending');
            $table->timestamps();

            $table->unique('leader_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clans');
    }
};
