<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('fullname')->nullable()->after('id');
            $table->string('nickname')->nullable()->after('fullname');
            $table->enum('role', ['player', 'leader', 'admin'])->default('player')->after('email');

            $table->unsignedBigInteger('clan_id')->nullable()->after('role');

            $table->boolean('is_active')->default(false)->after('clan_id');
            $table->string('phone')->nullable()->after('is_active');
            $table->string('payment_receipt')->nullable()->after('phone');
            $table->timestamp('activated_at')->nullable()->after('payment_receipt');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('clan_id');
            $table->dropColumn([
                'fullname',
                'nickname',
                'role',
                'is_active',
                'phone',
                'payment_receipt',
                'activated_at',
            ]);
        });
    }
};
